<?php

use Illuminate\Support\Facades\Route;

Route::middleware('auth')->name('user.')->group(function () {
    Route::middleware(['check.status'])->group(function () {
        Route::middleware('registration.complete')->namespace('User')->controller('UserController')->group(function () {
            Route::any('deposit/history', 'depositHistory')->name('deposit.history');
        });

        // Payment
        Route::middleware('registration.complete')->prefix('deposit')->name('deposit.')->controller('Gateway\PaymentController')->group(function () {
            Route::get('confirm', 'depositConfirm')->name('confirm');
            Route::get('manual', 'manualDepositConfirm')->name('manual.confirm');
            Route::post('manual', 'manualDepositUpdate')->name('manual.update');
        });
    });
});

Route::get('social-login/callback/{provider}', 'UserController@callback')->name('user.social.login.callback');