<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
 */

Route::namespace('Api')->name('api.')->group(function () {

    Route::controller('AppController')->group(function () {
        Route::get('general-setting', 'generalSetting');
        Route::get('get-countries', 'getCountries');
        Route::get('language/{key?}', 'getLanguage');
        Route::get('policies', 'policies');
        Route::get('faq', 'faq');
        Route::get('module-setting', 'moduleSetting')->name('module.setting');
    });

    Route::namespace('Auth')->group(function () {
        Route::controller('LoginController')->group(function () {
            Route::post('login', 'login');
            Route::post('check-token', 'checkToken');
        });
        Route::post('register', 'RegisterController@register');

        Route::controller('ForgotPasswordController')->group(function () {
            Route::post('password/mobile', 'sendResetCodeMobile');
            Route::post('password/verify-code', 'verifyCode');
            Route::post('password/reset', 'reset');
        });
    });

    Route::middleware('auth:sanctum')->group(function () {

        Route::post('user-data-submit', 'UserController@userDataSubmit');

        //authorization
        Route::middleware('registration.complete')->controller('AuthorizationController')->group(function () {
            Route::get('authorization', 'authorization');
            Route::get('resend-verify/{type}', 'sendVerifyCode');
            Route::post('verify-email', 'emailVerification');
            Route::post('verify-mobile', 'mobileVerification');
            Route::post('verify-g2fa', 'g2faVerification');
        });

        Route::middleware(['check.status'])->group(function () {

            Route::middleware('registration.complete')->group(function () {

                Route::controller('UserController')->group(function () {
                    Route::get('dashboard', 'dashboard');
                    Route::get('user-info', 'userInfo');
                    Route::post('profile-setting', 'submitProfile');
                    Route::post('change-password', 'submitPassword');

                    Route::post('/qr-code/scan', 'qrCodeScan')->name('qr.code.scan');
                    Route::get('/qr-code', 'qrCode')->name('qr.code');
                    Route::post('/qr-code/download', 'qrCodeDownload')->name('qr.code.download');
                    Route::post('/qr-code/remove', 'qrCodeRemove')->name('qr.code.remove');

                    Route::get('limit-charge', 'trxLimit');

                    Route::get('notification/settings', 'notificationSettings')->name('notification.settings');
                    Route::post('notification/settings', 'notificationSettingsUpdate')->name('notification.settings.update');
                    Route::post('remove/promotional/notification/image', 'removePromotionalNotificationImage')->name('remove.promotional.notification.image');

                    Route::post('pin/validate', 'validatePin');

                    //KYC
                    Route::get('kyc-form', 'kycForm');
                    Route::post('kyc-submit', 'kycSubmit');

                    //Report
                    Route::any('deposit/history', 'depositHistory');
                    Route::get('transactions', 'transactions');

                    // Notification
                    Route::post('add-device-token', 'addDeviceToken');
                    Route::get('push-notifications', 'pushNotifications');
                    Route::post('push-notifications/read/{id}', 'pushNotificationsRead');

                    //2FA
                    Route::get('twofactor', 'show2faForm');
                    Route::post('twofactor/enable', 'create2fa');
                    Route::post('twofactor/disable', 'disable2fa');

                    Route::post('account/delete', 'accountDelete');
                });

                Route::controller('OtpController')->group(function () {
                    Route::post('otp-verify', 'otpVerify')->name('verify.otp.submit');
                    Route::post('otp-resend', 'otpResend')->name('verify.otp.resend');
                });

                // Savings
                Route::controller('SavingAccountController')->middleware('kyc:web')->prefix('savings-account')->name('savings-account.')->group(function () {
                    Route::get('/nominees', 'nominees')->name('nominees');
                    Route::get('/organizations', 'organizationList')->name('organization.list');
                    Route::get('/nominee-form', 'nomineeForm')->name('nominee.form');
                    Route::post('/nominee/create', 'nomineeCreate')->name('nominee.create');
                    Route::post('/nominee/delete', 'nomineeDelete')->name('nominee.delete');
                    Route::post('/create', 'createSavingsAccount')->name('create')->middleware('module:savings');
                    Route::post('/create-done/{actionId?}', 'createSavingsAccountDone')->name('create.done')->middleware('module:savings');
                    Route::get('/list', 'list')->name('list');
                    Route::get('/details/{id}', 'accountDetails')->name('details');
                    Route::post('/closed/{id}', 'accountClosed')->name('closed');

                    Route::get('/data', 'data')->name('data');
                });

                // Points
                Route::controller('PointsController')->name('points.')->prefix('points')->group(function () {
                    Route::get('/earned', 'earnedPoints')->name('earnded');
                    Route::get('/used', 'usedPoints')->name('used');
                    Route::get('/expired', 'expiredPoints')->name('expired');
                });

                // Level & Rewards
                Route::controller('LevelRewardsController')->name('level.reward.')->prefix('level-reward')->group(function () {
                    Route::get('/data', 'data')->name('data');
                    Route::get('/list', 'levelWithRewards')->name('list');
                    Route::get('/faq', 'faq')->name('faq');
                });

                // Redeem Rewards
                Route::controller('RedeemRewardsController')->name('redeem.reward')->prefix('redeem-reward')->group(function () {
                    Route::get('/list', 'list')->name('list');
                    Route::post('/store', 'store')->name('store');
                });

                //Cash out
                Route::controller('CashOutController')->middleware(['module:cash_out', 'kyc:web,cash_out'])->group(function () {
                    Route::post('agent/exist', 'checkUser')->name('agent.check.exist');
                    Route::get('cash-out', 'cashOut')->name('cash.out');
                    Route::post('cash-out', 'cashOutConfirm');
                    Route::post('cash-out-done/{actionId?}', 'cashOutDone')->name('cash.out.done');
                    Route::get('cash-out/history', 'cashOutHistory')->name('cash.out.history');
                });

                //Make payment
                Route::controller('MakePaymentController')->middleware(['module:make_payment', 'kyc:web,make_payment'])->group(function () {
                    Route::post('/merchant/exist', 'checkUser')->name('merchant.check.exist');
                    Route::get('/make-payment', 'makePayment')->name('make.payment');
                    Route::post('/make-payment', 'makePaymentConfirm');
                    Route::post('/make-payment-done/{actionId?}', 'makePaymentDone')->name('make.payment.done');
                    Route::get('/make-payment/history', 'makePaymentHistory')->name('make.payment.history');
                });

                //Send money
                Route::controller('SendMoneyController')->middleware(['module:send_money', 'kyc:web,send_money'])->group(function () {
                    Route::get('/send/money', 'sendMoney')->name('send.money');
                    Route::post('/send/money', 'sendMoneyConfirm');
                    Route::post('/send/money-done/{actionId?}', 'sendMoneyDone')->name('send.money.done');
                    Route::post('/user/exist', 'checkUser')->name('check.exist');
                    Route::get('/send/money/history', 'sendMoneyHistory')->name('send.money.history');
                });

                //Pay bill
                Route::controller('PayBillController')->middleware(['module:utility_bill', 'kyc:web,pay_bill'])->group(function () {
                    Route::get('/pay/bill', 'payBill')->name('pay.bill');
                    Route::post('/pay/bill', 'payBillConfirm')->name('pay.bill.confirm');
                    Route::post('/pay/bill-done/{actionId?}', 'payBillDone')->name('pay.bill.done');
                    Route::get('/pay/bill/history', 'payBillHistory')->name('pay.bill.history');
                    Route::get('/pay/bill/download/{id}', 'payBillDownload')->name('pay.bill.download');
                });

                //Mobile recharge
                Route::controller('MobileRechargeController')->middleware(['module:mobile_recharge', 'kyc:web,mobile_recharge'])->group(function () {
                    Route::get('/mobile/recharge', 'mobileRecharge')->name('mobile.recharge');
                    Route::post('/mobile/recharge', 'mobileRechargeConfirm');
                    Route::post('/mobile/recharge-done/{actionId?}', 'mobileRechargeDone')->name('mobile.recharge.done');
                    Route::get('/mobile/recharge/history', 'mobileRechargeHistory')->name('mobile.recharge.history');
                });

                //Donation
                Route::controller('DonationController')->middleware(['module:donation', 'kyc:web,donation'])->group(function () {
                    Route::get('/donation', 'donation')->name('donation');
                    Route::post('/donation', 'donationConfirm');
                    Route::post('/donation-done/{actionId?}', 'donationDone')->name('donation.done');
                    Route::get('/donation/history', 'donationHistory')->name('donation.history');
                });

                //Bank Transfer
                Route::controller('BankTransferController')->middleware(['module:bank_transfer', 'kyc:web,bank_transfer'])->group(function () {
                    Route::post('/add/bank', 'addBank')->name('add.bank');
                    Route::get('/bank/details/{id}', 'bankDetails')->name('bank.details');
                    Route::post('/update/bank', 'updateBank')->name('update.bank');
                    Route::post('/delete/bank', 'deleteBank')->name('delete.bank');

                    Route::get('/bank/transfer', 'bankTransfer')->name('bank.transfer');
                    Route::post('/bank/transfer', 'bankTransferConfirm');
                    Route::post('/bank/transfer-done/{actionId?}', 'bankTransferDone')->name('bank.transfer.done');

                    Route::get('/bank/transfer/history', 'bankTransferHistory')->name('bank.transfer.history');
                });

                Route::controller('AirtimeController')->prefix('airtime')->middleware(['module:air_time'])->group(function () {
                    Route::get('countries', 'countries');
                    Route::get('operators-by-country/{id}', 'getOperatorByCountry');

                    Route::post('top-up', 'topUpConfirm');
                    Route::post('top-up/done/{actionId?}', 'topUpDone')->name('top.up.done');

                    Route::get('history', 'history');
                });

                Route::controller('VoucherController')->middleware(['module:create_voucher', 'kyc:web,create_voucher'])->group(function () {
                    Route::get('/voucher/list', 'userVoucherList');
                    Route::get('voucher/create', 'userVoucher');
                    Route::post('voucher/create', 'userVoucherCreate');
                    Route::post('/voucher/create/done/{actionId?}', 'userVoucherCreateDone')->name('voucher.create.done');
                    Route::get('/voucher/redeem/log', 'userVoucherRedeemLog');
                    Route::post('/voucher/redeem', 'userVoucherRedeemConfirm');
                });

                Route::controller('RequestMoneyController')->middleware(['module:request_money', 'kyc:web,request_money'])->group(function () {
                    Route::get('requests', 'allRequests');
                    Route::get('my/requested/history', 'requestedHistory');
                    Route::get('request/money', 'requestMoney');
                    Route::post('request/money', 'confirmRequest');
                    Route::post('request/accept', 'requestAccept')->name('request.accept');
                    Route::post('request/reject', 'requestReject')->name('request.reject');
                    Route::any('accept/done/{actionId?}', 'requestAcceptDone')->name('request.accept.done');
                });

                Route::post('user/exist', 'SendMoneyController@checkUser')->name('check.exist');

                // Payment
                Route::controller('PaymentController')->middleware(['module:add_money'])->group(function () {
                    Route::get('deposit/methods', 'methods')->name('deposit');
                    Route::post('deposit/insert', 'depositInsert')->name('deposit.insert');
                    Route::get('deposit/confirm', 'depositConfirm')->name('deposit.confirm');
                    Route::get('deposit/manual', 'manualDepositConfirm')->name('deposit.manual.confirm');
                    Route::post('deposit/manual', 'manualDepositUpdate')->name('deposit.manual.update');
                });

                Route::controller('TicketController')->prefix('ticket')->group(function () {
                    Route::get('/', 'supportTicket');
                    Route::post('create', 'storeSupportTicket');
                    Route::get('view/{ticket}', 'viewTicket');
                    Route::post('reply/{id}', 'replyTicket');
                    Route::post('close/{id}', 'closeTicket');
                    Route::get('download/{attachment_id}', 'ticketDownload');
                });

                // Invoice
                Route::controller('InvoiceController')->middleware(['module:invoice'])->prefix('invoice')->name('invoice')->group(function () {
                    Route::get('/', 'index');
                    Route::post('payment/{id}', 'payment');
                    Route::post('done/{actionId}', 'invoiceDone')->name('.done');
                    Route::post('reject/{id}', 'reject');
                    Route::get('download/{id}', 'download');
                });

                // Auto Payment
                Route::controller('AutoPaymentController')->middleware(['module:auto_payment'])->prefix('auto-payment')->name('auto.payment.')->group(function () {
                    Route::get('/', 'index')->name('index');
                    Route::post('remove/{id}', 'remove')->name('remove');
                    // Pay bill
                    Route::post('pay-bill', 'payBillConfirm')->name('pay.bill.confirm');
                    Route::post('pay-bill/done', 'payBillDone')->name('pay.bill.done');
                    // Send money
                    Route::post('send-money', 'sendMoneyConfirm')->name('send.money.confirm');
                    Route::post('send-money/done', 'sendMoneyDone')->name('send.money.done');
                    // Mobile Recharge
                    Route::post('mobile-recharge', 'mobileRechargeConfirm')->name('mobile.recharge.confirm');
                    Route::post('mobile-recharge/done', 'mobileRechargeDone')->name('mobile.recharge.done');
                });
            });
        });

        Route::get('logout', 'Auth\LoginController@logout');
    });
});
