<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link type="image/x-icon" href="{{ getImage('assets/images/logoIcon/favicon.png') }}" rel="icon">

    <style>
        body {
            box-sizing: border-box;
            background-color: #ffffff;
            font-family: "Quicksand", sans-serif;
        }

        h1,
        h2,
        h3,
        h4,
        h5,
        h6 {
            margin: 0;
            color: #456;
        }

        p {
            color: #678;
            margin-top: 10px;
            margin-bottom: 10px;
        }

        ul {
            padding: 0;
            margin: 0;
            list-style: none;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th,
        td {
            border: 1px solid #ddd;
            text-align: left;
            padding: 8px;
        }

        .ticket-wrapper {
            width: 7in;
            margin: 0 auto;
            padding: 20px;
            border-radius: 10px;
            background: #fff;
            box-shadow: 0 5px 35px rgba(0, 0, 0, .1);
        }

        .info {
            margin-top: 2rem;
            margin-bottom: 2rem;
            text-align: center;
        }

        .ticket-logo img {
            width: 50%;
        }

        .ticket-logo {

            text-align: center;
        }

        .d-float {
            float: left;

        }

        .user-data img {

            width: 100%;

        }

        .user-data__item {
            width: 50%;
            float: left;
        }
    </style>
</head>

<body>

    <div class="ticket-wrapper">
        <div class="ticket-inner">
            <div class="ticket-header">
                <div class="ticket-logo"><img src="{{ siteLogo(2) }}" alt="Logo"></div>
                <div class="ticket-header-content">
                    <p class="info">@lang('Utility Bill Receipt')</p>
                </div>
            </div>
            <div class="border"></div>
            <div class="ticket-body ">

                <table>
                    <tr>
                        <th>Date/Time</th>
                        <th>Utility Bill</th>
                        <th>Trx</th>
                        <th>Status</th>
                        <th>Username</th>
                        <th>Amount</th>
                        
                    </tr>
                    <tr>
                        
                        <td>{{ showDateTime($payBill->created_at) }}</td>
                        <td>{{ $payBill->setupUtilityBill->name }}</td>

                        <td>{{ $payBill->trx }}</td>
                        <td>@php echo $payBill->statusBadge @endphp</td>
                        <td>{{ $payBill->user->username }}</td>
                        <td>{{ showAmount($payBill->amount) }}</td>
                    </tr>

                
                </table>

                @php 
                    $filteredData = array_filter(json_decode(json_encode($payBill->user_data), true), function ($entry) {
                        return $entry['type'] != 'file';
                    });
                @endphp

                @if($filteredData)
                    <div class="ticket-header-content">
                        <p class="info">@lang('Bill Information')</p>
                    </div>
                @endif
            
                <div>
                    <table>
                        <tbody>
                            @foreach ($payBill->user_data as $data)
                                @if ($data->type != 'file')
                                    <tr>
                                        <th>{{ $data->name }}</th>
                                        <td>
                                            @foreach((array) $data->value as $index => $value)
                                                {{ $value }}@if(!$loop->last), @endif
                                            @endforeach
                                        </td>
                                    </tr>
                                @endif
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
</body>

</html>
