@php
    $appDetail = getContent('app_details.content', true);
    $appDetails = getContent('app_details.element', orderById: true);
    $appLink = @getContent('app_link.content',true)->data_values;

    $accountStep = getContent('account_step.content', true);
    $accountSteps = getContent('account_step.element', orderById: true);

    $testimonial = getContent('testimonial.content', true);
    $testimonials = getContent('testimonial.element', orderById: true);
@endphp
<section id="whyChoseUs" class="why-chose-us-section">
    <div class="main-feature py-60">
        <div class="feature">
            <div class="container">
                <div class="row align-items-center flex-row-reverse gy-5">
                    <div class="col-md-7">
                        <div class="section-heading style-left">
                            <h3 class="section-heading__title">{{ __(@$appDetail->data_values->heading) }}</h3>
                            <p class="section-heading__desc">{{ __(@$appDetail->data_values->subheading) }}</p>
                        </div>
                        <ul class="feature-list">
                            @foreach ($appDetails as $app)
                                <li class="feature-item flex-align">
                                    <span class="icon">@php echo @$app->data_values->feature_icon @endphp</span>
                                    {{ __(@$app->data_values->feature_text) }}
                                </li>
                            @endforeach
                        </ul>

                        <div class="cta-section gap-3 flex-align">
                             <a href="{{ @$appLink->user_app_download_link_android }}" >
                                <img src="{{ getImage('assets/images/frontend/app_link/' . @$appLink->play_store_image, '180x50') }}" alt="@lang('image')">
                            </a>
                            <a href="{{ @$appLink->user_app_download_link_ios }}" >
                                <img src="{{ getImage('assets/images/frontend/app_link/' . @$appLink->app_store_image, '180x50') }}" alt="@lang('image')">
                            </a>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="section-img">
                            <img src="{{ getImage('assets/images/frontend/app_details/' . @$appDetail->data_values->image, '380x770') }}">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="feature">
            <div class="container">
                <div class="row align-items-center flex-row-reverse gy-5">
                    <div class="col-md-7">
                        <div class="account-complete-process">
                            <h3 class="section-heading__title">{{ __(@$accountStep->data_values->heading) }}</h3>
                            <ul class="process-list">
                                @foreach ($accountSteps as $accountStep)
                                    <li class="process-item {{ !$loop->index ? 'active' : '' }}" data-change-img="account{{ $loop->iteration }}">
                                        <h5 class="process-item__title">{{ __(@$accountStep->data_values->title) }}</h5>
                                        <p class="process-item__desc">{{ __(@$accountStep->data_values->subtitle) }}</p>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="section-img process-thumb">
                            <div class="img-frame">
                                @foreach ($accountSteps as $accountStep)
                                    <img id="account{{ $loop->iteration }}" {{ $loop->index ? 'hidden' : '' }} src="{{ getImage('assets/images/frontend/account_step/' . @$accountStep->data_values->images, '380x770') }}" alt="@lang('image')">
                                @endforeach
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <div class="feature testimonial">
            <div class="container">
                <div class="row g-3 gx-5 g-lg-5 flex-row-reverse">
                    <div class="col-md-6">
                        <div class="section-heading style-left">
                            <h3 class="section-heading__title">{{ __(@$testimonial->data_values->heading) }}</h3>
                            <p class="section-heading__desc">{{ __(@$testimonial->data_values->subheading) }}</p>
                        </div>
                    </div>
                    @if ($testimonials->count())
                        <div class="col-md-6">
                            <div class="testimonial-card">
                                <div class="testimonial-card__content">
                                    <h5 class="testimonial-card__title">{{ __(@$testimonials[0]->data_values->quote_title) }}</h5>
                                    <p class="testimonial-card__desc">{{ __(@$testimonials[0]->data_values->quote) }}</p>
                                </div>
                                <address class="user flex-align">
                                    <div class="user__thumb">
                                        <img src="{{ getImage('assets/images/frontend/testimonial/' . @$testimonials[0]->data_values->author_image, '80x80') }}">
                                    </div>
                                    <div class="user__info">
                                        <h6 class="user__name">{{ __(@$testimonials[0]->data_values->author_name) }}</h6>
                                        <p class="user__address">{{ __(@$testimonials[0]->data_values->designation) }}</p>
                                    </div>
                                </address>
                            </div>
                        </div>
                    @endif
                </div>
                <div class="row g-2  g-lg-5">
                    @foreach ($testimonials as $testimonial)
                        @continue(!$loop->index)
                        <div class="col-md-6">
                            <div class="testimonial-card">
                                <div class="testimonial-card__content">
                                    <h5 class="testimonial-card__title">{{ __(@$testimonial->data_values->quote_title) }}</h5>
                                    <p class="testimonial-card__desc">{{ __(@$testimonial->data_values->quote) }}</p>
                                </div>
                                <address class="user flex-align">
                                    <div class="user__thumb">
                                        <img src="{{ getImage('assets/images/frontend/testimonial/' . @$testimonial->data_values->author_image, '80x80') }}">
                                    </div>
                                    <div class="user__info">
                                        <h6 class="user__name">{{ __(@$testimonial->data_values->author_name) }}</h6>
                                        <p class="user__address">{{ __(@$testimonial->data_values->designation) }}</p>
                                    </div>
                                </address>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</section>
