@php
    $features = getContent('feature.element', orderById: true);
@endphp
<div id="features" class="features-section pt-60">
    <div class="container">
        <div class="row">
            <div class="col-md-6">
                <div class="right-content">
                    @foreach ($features as $feature)
                        <div class="contentMarker" data-marker-content="img{{ $loop->iteration }}">
                            <h4 class="section-heading">{{ __(@$feature->data_values->title) }}</h4>
                            <p>{{ __(@$feature->data_values->subtitle) }}</p>
                            <div class="mobile-img">
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
            <div class="col-md-5 d-md-block d-none ml-auto">
                <div class="left-content">
                    @foreach ($features as $feature)
                        <img id="img{{ $loop->iteration }}" class="imageToShow" src="{{ getImage('assets/images/frontend/feature/' . @$feature->data_values->image, '525x675') }}" alt="feature-img">
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
