@php
    $cta = getContent('cta.content', true);
    $appLink = @getContent('app_link.content',true)->data_values;
@endphp

<section class="cta-section">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="banner-content">
                    <h1 class="banner-content__title text-center">{{ __(@$cta->data_values->heading) }}</h1>
                    <p class="banner-content__desc text-center">{{ __(@$cta->data_values->subheading) }}</p>
                    <div class="banner-content__button flex-center gap-3">
                        <div class="multi-download">
                            <button class="btn btn--base">@lang('Download')</button>
                            <ul class="multi-download__list">
                                 <li class="multi-download__item">
                                    <a class="multi-download__link" href="{{@$appLink->merchant_app_download_link_android}}">@lang("Download for Android (Merchant)")</a>
                                </li>
                                <li class="multi-download__item">
                                    <a class="multi-download__link" href="{{@$appLink->merchant_app_download_link_ios}}">@lang("Download for IOS (Merchant)")</a>
                                </li>
                            </ul>
                        </div>
                        <a href="{{ @$cta->data_values->button_link }}" class="btn btn-outline--base">{{ __(@$cta->data_values->button_text) }}</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
