@php
    if (userGuard()['type'] == 'AGENT' || userGuard()['type'] == 'MERCHANT') {
        $class = 'mt-5';
        $layoutName = strtolower(userGuard()['type']) . '_master';
    } else {
        $layoutName = 'frontend';
        $class = 'py-60';
    }
@endphp

@extends($activeTemplate . "layouts.$layoutName")

@section('content')
    <div class="container">
        <div class="row justify-content-center {{ @$class }}">
            <div class="col-md-8">
                <div class="card custom--card">
                    <div class="card-header card-header-bg">
                        <h5 class="card-title">{{ __($pageTitle) }}</h5>
                    </div>
                    <div class="card-body  ">
                        <form action="{{ route(strtolower(userGuard()['type']) . '.deposit.manual.update') }}" id="payment-form" method="POST" enctype="multipart/form-data" class="disableSubmission">
                            @csrf
                            <div class="row">
                                <div class="alert alert-primary">
                                    <p class="mb-0"><i class="las la-info-circle"></i> @lang('You are requesting') <b>{{ showAmount($data['amount']) }}</b> @lang('to deposit.') @lang('Please pay')
                                        <b>{{ showAmount($data['final_amount'], currencyFormat: false) . ' ' . $data['method_currency'] }} </b> @lang('for successful payment.')
                                    </p>
                                </div>

                                <div class="mb-3">@php echo  $data->gateway->description @endphp</div>

                                <x-viser-form identifier="id" identifierValue="{{ $gateway->form_id }}" />

                                <div class="col-md-12">
                                    <div class="form-group">
                                        <button type="submit" class="btn btn--base w-100">@lang('Pay Now')</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
