@if(gs('otp_verification') && (gs('en') || gs('sn') || agent()->ts))
    <div class="p-4 border mt-4">
        <div class="row">
            <div class="col-lg-12 form-group">
                <label class="mb-0">@lang('OTP Type')</label>
                <select class="select style--two currency select2" name="otp_type" required data-minimum-results-for-search="-1">
                    <option value="" selected>@lang('Select One')</option>
                    @if(gs('en'))
                        <option value="email">@lang('Email')</option>
                    @endif
                    @if(gs('sn'))
                        <option value="sms">@lang('SMS')</option>
                    @endif
                    @if (@userGuard()['user']->ts == Status::ENABLE)
                        <option value="2fa">@lang('2FA')</option>
                    @endif
                </select>
            </div>
        </div><!-- row end -->
    </div>
@endif

@push('script')
    <script>
        'use strict';
        (function ($) {
            var old = @json(session()->getOldInput());
            if(old.length != 0){
                $('select[name=otp_type]').val(old.otp_type);
            }
        })(jQuery);
    </script>
@endpush







 