@php
    $appLink = @getContent('app_link.content',true)->data_values;
@endphp


<div class="header-mobile-space d-block d-lg-none pt-5"></div>
<header class="header" id="header">
    <div class="container">
        <nav class="navbar navbar-expand-lg navbar-light">
            <a class="navbar-brand logo" href="{{ route('home') }}"><img src="{{ siteLogo(2) }}" alt="@lang('Logo')"></a>
            <button class="navbar-toggler header-button" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <span id="hiddenNav"><i class="las la-bars"></i></span>
            </button>

            <div class="collapse navbar-collapse flex-align" id="navbarSupportedContent">
                <ul class="navbar-nav nav-menu ms-auto align-items-lg-center">
                    <li class="nav-item">
                        <a class="nav-link" href="{{ route('home') }}">@lang('HOME')</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="{{ request()->routeIs('home') ? '' : route('home') }}#about">@lang('ABOUT')</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="{{ request()->routeIs('home') ? '' : route('home') }}#features">@lang('FEATURES')</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="{{ request()->routeIs('home') ? '' : route('home') }}#whyChoseUs">@lang('Why Chose Us')</a>
                    </li>
                    @php
                        $pages = App\Models\Page::where('tempname', $activeTemplate)
                            ->where('is_default', Status::NO)
                            ->get();
                    @endphp
                    @foreach ($pages as $page)
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('pages', [$page->slug]) }}">{{ __($page->name) }}</a>
                        </li>
                    @endforeach
                    <li class="nav-item">
                        <a class="nav-link" href="{{ route('contact') }}">@lang('CONTACT')</a>
                    </li>
                    <li class="header-btn flex-wrap flex-shrink-0 mt-lg-0 mt-3">
                        <div class="multi-download">
                            <button class="btn btn--base">@lang('Download')</button>
                            <ul class="multi-download__list">
                                 <li class="multi-download__item">
                                    <a class="multi-download__link" href="{{@$appLink->agent_app_download_link_android}}">@lang("Download for Android (Agent)")</a>
                                </li>
                                <li class="multi-download__item">
                                    <a class="multi-download__link" href="{{@$appLink->agent_app_download_link_ios}}">@lang("Download for IOS (Agent)")</a>
                                </li>

                            </ul>
                        </div>
                        <a href="{{ route('agent.login') }}" class="btn btn-outline--base">@lang('Agent Login')</a>
                    </li>
                </ul>
            </div>
        </nav>
    </div>
</header>


@if (session('app'))
    <style>
        .header-mobile-space {
            display: none !important;
        }

        .header {
            display: none !important;
        }
    </style>
@endif
