@php
    $policyPages = getContent('policy_pages.element', false, null, true);
@endphp
<footer class="footer-area">
    <div class="py-60">
        <div class="container">
            <div class="row justify-content-between flex-align gy-3">
                <div class="col-lg-6">
                    <div class="footer-item__logo">
                        <a href="{{ route('home') }}"> <img src="{{ siteLogo(2) }}" alt="@lang('Logo')"></a>
                    </div>
                </div>
                <div class="col-lg-6">
                    <ul class="footer-menu">
                        <li class="footer-menu__item"><a href="{{ route('api.documentation') }}" class="footer-menu__link">@lang('Api Documentation')</a></li>
                        @foreach ($policyPages as $policy)
                            <li class="footer-menu__item"><a href="{{ route('policy.pages', $policy->slug) }}" class="footer-menu__link">{{ __($policy->data_values->title) }}</a></li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- Footer Top End-->

    <!-- bottom Footer -->
    <div class="bottom-footer py-3">
        <div class="container">
            <div class="row gy-3">
                <div class="col-md-6">
                    <div class="bottom-footer-text">&copy; {{ date('Y') }} <a href="{{ route('home') }}" class="text--base">{{ __(gs('site_name')) }}</a>. @lang('All Rights Reserved')</div>
                </div>

                <div class="col-md-6 text-right">
                    @if (gs('multi_language'))
                        @php
                            $language = App\Models\Language::all();
                            $currentLang = $language->where('code', session('lang'))->first();
                        @endphp

                        <div class="ms-auto">
                            <div class="language dropdown">
                                <button class="language-wrapper" data-bs-toggle="dropdown" aria-expanded="false">
                                    <div class="language-content">
                                        <div class="language_flag">
                                            <img src="{{ getImage(getFilePath('language') . '/' . @$currentLang->image, getFileSize('language')) }}" alt="flag">
                                        </div>
                                        <p class="language_text_select">{{ __(@$currentLang->name) }}</p>
                                    </div>
                                    <span class="collapse-icon"><i class="las la-angle-down"></i></span>
                                </button>

                                <div class="dropdown-menu langList_dropdow py-2">
                                    <ul class="langList">
                                        @foreach ($language as $item)
                                            @if (session('lang') != $item->code)
                                                <li class="language-list languageList" data-code="{{ $item->code }}">
                                                    <div class="language_flag">
                                                        <img src="{{ getImage(getFilePath('language') . '/' . $item->image, getFileSize('language')) }}" alt="flag">
                                                    </div>
                                                    <p class="language_text">{{ __($item->name) }}</p>
                                                </li>
                                            @endif
                                        @endforeach
                                    </ul>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</footer>

@push('script')
    <script>
        (function($) {
            "use strict";

            const $mainlangList = $(".langList");
            const $langBtn = $(".language-content");
            const $langListItem = $mainlangList.children();

            $langListItem.each(function() {
                const $innerItem = $(this);
                const $languageText = $innerItem.find(".language_text");
                const $languageFlag = $innerItem.find(".language_flag");

                $innerItem.on("click", function(e) {
                    $langBtn.find(".language_text_select").text($languageText.text());
                    $langBtn.find(".language_flag").html($languageFlag.html());
                });
            });

        })(jQuery);
    </script>
@endpush
