@extends($activeTemplate . 'layouts.merchant_master')

@section('content')
    <div class="row justify-content-center mt-5">
        <div class="custom--card">
            <div class="card-body">
                <div class="row align-items-center mb-3">
                    <div class="col-8">
                        <h6>{{ __($pageTitle) }}</h6>
                    </div>
                    <div class="col-4 text-end">
                        <button class="trans-serach-open-btn me-2"><i class="las la-search"></i></button>
                        <a href="{{ route('merchant.invoice.create') }}" class="btn btn-sm btn-primary"><i class="las la-plus"></i> @lang('New Invoice')</a>
                    </div>
                </div>
                <div class="table-responsive--sm">
                    <form class="transaction-top-form mb-4" action="" method="GET">
                        <div class="custom-select-search-box">
                            <input type="search" name="search" class="form--control" value="{{ request()->search }}" placeholder="@lang('Search...')">
                            <button type="submit" class="search-box-btn">
                                <i class="las la-search"></i>
                            </button>
                        </div>
                    </form>
                    <table class="table custom--table">
                        <thead>
                            <tr>
                                <th>@lang('Invoice To')</th>
                                <th>@lang('Invoice No')</th>
                                <th>@lang('Total Items')</th>
                                <th>@lang('Amount')</th>
                                <th>@lang('Status')</th>
                                <th>@lang('Action')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($invoices as $invoice)
                                <tr>

                                    <td>
                                        <span class="fw-bold">
                                            <span class="text-primary">{{ __(@$invoice->user->fullname) }}</span>
                                        </span>
                                        <br>
                                        <small>{{ @$invoice->user->mobileNumber }}</small>
                                    </td>
                                    <td>
                                        #{{ $invoice->uid }}
                                    </td>
                                    <td>
                                        {{ $invoice->total_item }}
                                    </td>
                                    <td>
                                        {{ showAmount($invoice->total_amount) }}
                                    </td>
                                    <td>
                                        @php echo $invoice->statusBadge @endphp
                                    </td>
                                    <td>
                                        @if ($invoice->status == Status::UNPAID)
                                            <a href="{{ route('merchant.invoice.edit', $invoice->id) }}" class="btn btn-primary btn-sm"><i class="las la-edit"></i></a>
                                            <button class="btn btn-danger btn-sm cancelBtn" data-action="{{ route('merchant.invoice.cancel', $invoice->id) }}"><i class="las la-times"></i></button>
                                        @endif
                                        <a href="{{ route('merchant.invoice.detail', $invoice->id) }}" class="btn btn-dark btn-sm"><i class="fa fa-desktop"></i></a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td class="text-muted text-center not-found" colspan="100%">{{ __($emptyMessage) }}</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                @if ($invoices->hasPages())
                    <div class="pt-4 pb-2">
                        {{ paginatelinks($invoices) }}
                    </div>
                @endif
            </div>
        </div>
    </div>

    <div id="cancelModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Cancel Invoice')</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form method="post">
                        @csrf
                        <div class="form-group">
                            <label for="">@lang('Cancel Reason')</label>
                            <textarea class="form-control" name="cancel_reason" id="" cols="10" rows="1" required></textarea>
                        </div>
                        <div class="text-end">
                            <button type="submit" class="btn btn-primary btn-sm">@lang('Submit')</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div id="rejectModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p class="reason_text"></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn--dark btn-sm" data-bs-dismiss="modal">@lang('Close')</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <script>
        (function($) {
            "use strict";

            $('.rejectBtn').on('click', function() {
                var modal = $('#rejectModal');
                var title = $(this).data('title');
                var reason = $(this).data('reason');
                modal.find('.modal-title').text(title)
                modal.find('.reason_text').text(reason)
                modal.modal('show');
            })

            $('.cancelBtn').on('click', function() {
                var modal = $('#cancelModal');
                let action = $(this).data('action');
                modal.find('form').attr('action', action);
                modal.modal('show');
            })


            function getAmount(amount, length = 2) {
                amount = Math.round((amount ?? 0) * Math.pow(10, length)) / Math.pow(10, length);
                return amount + 0 + ` {{ gs('cur_text') }}`;
            }


            const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]')
            const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl))

        })(jQuery);
    </script>
@endpush

@push('style')
    <style>
        .produc-details-items {
            border: 1px solid #dfdfdfcc;
            padding: 10px;
            border-radius: 5px;
        }

        .produc-details-items>div {
            border-bottom: 1px solid #cccccc56;
            padding: 4px 0;
        }

        .produc-details-items>div:last-child {
            border-bottom: none;
            padding-bottom: none;
        }
    </style>
@endpush
