@extends($activeTemplate . 'layouts.merchant_master')

@section('content')
    <div class="row justify-content-center mt-5">
        <div class="card custom--card">
            <div class="card-body">
                <div class="row justify-content-center gy-4">
                    <div class="col-12">
                        <div class="d-flex flex-wrap align-items-center justify-content-between gap-2">
                            <h6>{{ __($pageTitle) }}</h6>
                            <div class="text-end">
                                <a href="{{ route('merchant.invoice.download', $invoice->id) }}" class="btn btn-sm btn-primary"><i class="las la-cloud-download-alt"></i> @lang('Download')</a>
                                <a href="{{ route('merchant.invoice.index') }}" class="btn btn-sm btn-dark"><i class="las la-undo"></i> @lang('Back')</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-8">
                        <div class="pdf-box">
                            <div class="pdf-header clearfix">
                                <div class="pdf-logo">
                                    <img src="{{ siteLogo() }}" alt="image">
                                </div>
                                <div class="right">
                                    <h4>@lang('Invoice') #{{ $invoice->uid }}</h4>
                                    <span>@lang('Issued:') {{ showDateTime($invoice->created_at, 'd M Y') }}</span>
                                </div>
                            </div>
                            <div class="pdf-body clearfix">
                                <div class="pdf-invoice-info clearfix">
                                    <div class="left_side">
                                        <b>@lang('Invoice To')</b>
                                        <span>{{ $invoice->user->fullname }}</span>
                                        <span>{{ $invoice->user->email }}</span>
                                        <span>{{ $invoice->user->mobileNumber }}</span>
                                    </div>
                                    <div class="right_side">
                                        <b>{{ $invoice->merchant->fullname }}</b>
                                        <span>{{ $invoice->merchant->email }}</span>
                                        <span>{{ $invoice->merchant->mobileNumber }}</span>
                                        @php
                                            $color = '';
                                            $status = '';
                                            if ($invoice->status == Status::PAID) {
                                                $color = 'success';
                                                $status = 'Paid';
                                            } elseif ($invoice->status == Status::UNPAID) {
                                                $color = 'primary';
                                                $status = 'Unpaid';
                                            } elseif ($invoice->status == Status::REJECTED) {
                                                $color = 'danger';
                                                $status = 'Rejected';
                                            } else {
                                                $color = 'warning';
                                                $status = 'Canceled';
                                            }
                                        @endphp
                                        <span class="button__{{ $color }}">{{ $status }}</span>
                                    </div>
                                </div>
                                <table class="invoice_table clearfix">
                                    <thead>
                                        <tr>
                                            <th width="50px">@lang('SL')</th>
                                            <th>@lang('Product Item')</th>
                                            <th>@lang('Amount')</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($invoice->invoiceItem as $item)
                                            <tr>
                                                <td>{{ $loop->iteration }}</td>
                                                <td class="text-left">{{ $item->name }}</td>
                                                <td>{{ showAmount($item->price) }}</td>
                                            </tr>
                                        @endforeach
                                        <tr>
                                            <td colspan="2">@lang('Total Amount: ')</b></td>
                                            <td>{{ showAmount($invoice->total_amount) }}</td>
                                        </tr>
                                    </tbody>
                                </table>
                                <span class="provide_by">@lang('Powered by') <b>{{ gs('site_name') }}</b></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('style')
    <style>
        .pdf-box {
            width: 750px;
            border: 1px solid #eee;
            margin: 0 auto;
            padding: 0;
            border-radius: 5px;
            overflow: auto;
        }

        .pdf-header {
            background: #1A46F4;
            padding: 20px 15px;
            text-align: right;
            color: #fff;
            display: block;

        }

        .pdf-header .pdf-logo {
            float: left;
            text-align: left;
            width: 50%;
            display: inline-block
        }

        .pdf-header .right {
            float: right;
            text-align: right;
            width: 50%;
            display: inline-block
        }

        .pdf-header h4 {
            color: #fff;
        }

        .pdf-body {
            padding: 15px;
        }

        .pdf-header .pdf-logo img {
            width: 200px;
        }

        .pdf-invoice-info {
            display: block;
            margin: 10px 0;
        }

        .pdf-invoice-info .left_side {
            float: left;
            width: 50%;
            display: inline-block;
        }

        .pdf-invoice-info .left_side>* {
            display: block;
        }


        .pdf-invoice-info .right_side {
            float: right;
            width: 50%;
            display: block;
            text-align: right
        }

        .pdf-invoice-info .right_side>* {
            display: block;
        }

        .button__success {
            color: #28C76F;
            background: #28c76f18;
            border: 1px solid #28c76f3a;
            padding: 0 20px;
            border-radius: 3px;
            display: inline-block !important;
            margin-top: 10px;
        }

        .button__danger {
            color: #FF0033;
            background: #FF003318;
            border: 1px solid #FF00333a;
            padding: 0 20px;
            border-radius: 3px;
            display: inline-block !important;
            margin-top: 10px;
        }

        .button__warning {
            color: #FDB13C;
            background: #FDB13C18;
            border: 1px solid #FDB13C3a;
            padding: 0 20px;
            border-radius: 3px;
            display: inline-block !important;
            margin-top: 10px;
        }

        .button__primary {
            color: #1A46F4;
            background: #1A46F418;
            border: 1px solid #1A46F43a;
            padding: 0 20px;
            border-radius: 3px;
            display: inline-block !important;
            margin-top: 10px;
        }

        .invoice_table {
            width: 100%;
            border-collapse: collapse;
        }

        .invoice_table thead th,
        .invoice_table tbody tr td {
            text-align: center;
        }

        .invoice_table thead th:first-child,
        .invoice_table tbody tr td:first-child {
            text-align: left;
        }

        .invoice_table thead th:last-child,
        .invoice_table tbody tr td:last-child {
            text-align: right;
        }

        .invoice_table,
        .invoice_table td,
        .invoice_table th {
            border: 1px solid #EEEEEE;
        }

        .invoice_table th,
        .invoice_table td {
            padding: 5px 10px;
        }

        .invoice_table th {
            background: #EEEEEE;
        }

        .invoice_table tbody tr:last-child {
            background: #EEEEEE;
        }

        .provide_by {
            margin-top: 20px;
            text-align: center;
            display: block;
        }

        .clearfix::after {
            content: "";
            clear: both;
            display: table;
        }
    </style>
@endpush
