@extends($activeTemplate . 'layouts.merchant_master')

@section('content')
    <div class="row justify-content-center mt-5">
        <div class="col-xl-10">
            <div class="card custom--card">
                <div class="card-header">
                    <div class="d-flex align-items-center flex-wrap gap-2 justify-content-between">

                        <h3 class="fw-semibold">@lang($pageTitle)</h3>
                        <a href="{{ route('merchant.invoice.index') }}" class="btn btn-outline-dark btn-sm float-end"> <i class="las la-undo"></i> @lang('Back')</a>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('merchant.invoice.store', @$invoice->id) }}" method="post" class="invoiceForm">
                        <div class="row  gy-4">
                            <div class="col-md-7">
                                <h6 class="mb-3">@lang('All Products')</h6>
                                @csrf
                                <div class="product-items">
                                    @if (request()->routeIs('merchant.invoice.create'))
                                        <div class="single-item pb-3">
                                            <input type="text" name="name[0]" class="form-control form-control-sm  w-100" placeholder="@lang('Product name')" required>
                                            <div class="input-group flex-shrink-1">
                                                <input type="number" step="any" class="form-control form-control-sm" placeholder="@lang('Amount')" name="amount[]" required>
                                                <input type="hidden" name="update[]" value="0" required>
                                                <span class="input-group-text fs-14">{{ gs('cur_text') }}</span>
                                            </div>
                                            <button type="button" class="btn btn-sm btn-danger flex-shrink-1 product-item-remove" disabled><i class="las la-times"></i></button>
                                        </div>
                                    @else
                                        @foreach ($invoice->invoiceItem as $invoiceItem)
                                            <div class="single-item pb-3">
                                                <input type="text" name="name[{{ $invoiceItem->id }}]" class="form-control form-control-sm w-100" placeholder="@lang('Product name')" value="{{ $invoiceItem->name }}" required>
                                                <input type="hidden" name="update[]" value="{{ $invoiceItem->id }}" required>
                                                <div class="input-group flex-shrink-1">
                                                    <input type="number" step="any" class="form-control form-control-sm" placeholder="@lang('Amount')" name="amount[]" value="{{ getAmount($invoiceItem->price) }}" required>
                                                    <span class="input-group-text fs-14">{{ gs('cur_text') }}</span>
                                                </div>
                                                <button type="button" class="btn btn-sm btn-danger flex-shrink-1 product-item-remove" data-item-id="{{ $invoiceItem->id }}" {{ @$invoice->invoice_item_count == 1 ? 'disabled' : '' }}><i class="las la-times"></i></button>
                                            </div>
                                        @endforeach
                                    @endif
                                </div>
                                <div class="product-items__bottom d-flex align-items-center justify-content-between mb-3">
                                    <button type="button" class="btn btn-sm btn-outline-primary product_item_plus">
                                        <i class="las la-plus"></i>
                                        @lang('Add Product')
                                    </button>
                                    <div class="invoice__info">
                                        <div id="total_product" class="invoice__info-item">
                                            <p class="label">@lang('Total Products: ')</p>
                                            <span class="value">{{ @$invoice->invoice_item_count ?? 0 }}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="invoice__info ms-auto">
                                    <div id="total_amount" class="invoice__info-item">
                                        <p class="label">@lang('Total: ')</p>
                                        <span class="value">{{ @$invoice->total_amount ? getAmount($invoice->total_amount) : 0 }} {{ gs('cur_sym') }}</span>
                                    </div>
                                </div>
                                <div class="invoice__info ms-auto">
                                    <div id="charge" class="invoice__info-item">
                                        <p class="label">@lang('System Charge: ')</p>
                                        <span class="value">0 {{ gs('cur_text') }}</span>
                                    </div>
                                </div>
                                <div class="invoice__info ms-auto">
                                    <div id="subtotal" class="invoice__info-item">
                                        <p class="label">@lang('Receivable Amount: ')</p>
                                        <span class="value">0 {{ gs('cur_text') }}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-5">
                                <h6 class="mb-3">@lang('Invoice Information')</h6>
                                @if (request()->routeIs('merchant.invoice.create'))
                                    <div class="form-group">
                                        <div class="input-group">
                                            <span class="input-group-text"><i class="las la-search"></i></span>
                                            <input type="search" class="form-control form-control search_username" name="username" placeholder="@lang('User / Customer...')" required>
                                        </div>
                                        <code class="text-danger not_found d-none">
                                            <i class="las la-exclamation-circle me-1"></i>
                                            @lang('User/Customer Not Found')
                                        </code>
                                    </div>
                                @endif
                                <div class="invoice__user-info">
                                    @if (request()->routeIs('merchant.invoice.edit'))
                                        <div class="invoice__info me-auto max-w-full">
                                            <div id="user_name" class="invoice__info-item">
                                                <p class="label">@lang('Username: ')</p>
                                                <span class="value">{{ $invoice->user->username }}</span>
                                            </div>
                                        </div>
                                    @endif
                                    <div class="invoice__info me-auto max-w-full">
                                        <div id="user_name" class="invoice__info-item">
                                            <p class="label">@lang('Name: ')</p>
                                            <span class="value">{{ request()->routeIs('merchant.invoice.edit') ? $invoice->user->fullname : '_' }}</span>
                                        </div>
                                    </div>
                                    <div class="invoice__info me-auto max-w-full">
                                        <div id="mobile_number" class="invoice__info-item">
                                            <p class="label">@lang('Mobile Number: ')</p>
                                            <span class="value">{{ request()->routeIs('merchant.invoice.edit') ? $invoice->user->mobileNumber : '_' }}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12">
                                <button type="submit" class="btn btn-sm btn-primary  w-100">
                                    @lang('Submit')
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <script>
        (function($) {
            "use strict";

            let validUser = `{{ request()->routeIs('merchant.invoice.index') ? false : true }}`;

            $('.invoiceForm').on('submit', function(e) {
                e.preventDefault();

                if (!validUser) {
                    notify('error', 'User not found');
                    return false;
                }

                this.submit();
            });

            $('.search_username').on('focusout', function() {
                let username = $(this).val();

                $.ajax({
                    type: "get",
                    url: "{{ route('merchant.invoice.user.search') }}",
                    data: {
                        username: username
                    },
                    dataType: "json",
                    success: function(response) {

                        validUser = response.success;

                        if (response.success) {
                            $('.not_found').addClass('d-none')
                            $('.invoice__info').find('#user_name span').text(response.fullname);
                            $('.invoice__info').find('#mobile_number span').text(response.mobile);

                        } else {
                            $('.not_found').removeClass('d-none')
                            $('.invoice__info').find('#user_name span').text('_');
                            $('.invoice__info').find('#mobile_number span').text('_');
                        }
                    }
                });
            });

            $(document).on('click', '.product-item-remove', function() {
                let childCount = $('.product-items').children().length;

                if (childCount > 1) {
                    $(this).parent().remove();
                }

                if (childCount <= 2) {
                    $('.product-items').find('.product-item-remove').attr('disabled', true);
                }

                productCalculation();
            });

            $(document).on('click', '.product_item_plus', function() {
                $('.product-items').append(`
                    <div class="single-item pb-3">
                        <input type="text" name="name[]" class="form-control form-control-sm w-100" placeholder="@lang('Product name')" required>
                        <input type="hidden" name="update[]" value="0" required>
                        <div class="input-group flex-shrink-1">
                            <input type="number" step="any" class="form-control form-control-sm" placeholder="@lang('Amount')" name="amount[]" required>
                            <span class="input-group-text fs-14">{{ gs('cur_text') }}</span>
                        </div>
                        <button type="button" class="btn btn-sm btn-danger flex-shrink-1 product-item-remove"><i class="las la-times"></i></button>
                    </div>
                `);
                $('.product-items').find('.product-item-remove').attr('disabled', false);
                productCalculation();
            })

            $(document).on('focusout', 'input[name="amount[]"]', function() {
                productCalculation();
            })

            function productCalculation() {
                let childs = $('.product-items').children()
                let childCount = childs.length;

                let amount = 0;
                $.each(childs, function(index, value) {
                    let itemAmount = $(value).find('input[name="amount[]"]').val();
                    if (itemAmount) {
                        amount += parseFloat(itemAmount) || 0;
                    }
                });
                let curText = `{{ gs('cur_sym') }}`;
                let fixedCharge = parseFloat(`{{ $paymentCharge->merchant_payment_fixed_charge }}`);
                let percentCharge = parseFloat(`{{ $paymentCharge->merchant_payment_percent_charge }}`);
                let totalCharge = (amount * (percentCharge / 100) + fixedCharge);
                let cap = `{{ $paymentCharge->cap }}`;

                if (cap != -1 && totalCharge > cap) {
                    totalCharge = parseFloat(cap);
                }
                let subTotal = amount - totalCharge;

                $('.invoice__info').find('#total_product span').text(childCount);
                $('.invoice__info').find('#total_amount span').text(curText + parseFloat(amount.toFixed(2)));
                $('.invoice__info').find('#charge span').text(curText + parseFloat(totalCharge.toFixed(2)));
                $('.invoice__info').find('#subtotal span').text(curText + parseFloat(subTotal.toFixed(2)));
            }

            productCalculation();

        })(jQuery);
    </script>
@endpush

@push('style')
    <style>
        .search_username,
        .search_username::placeholder {
            font-size: 14px
        }

        .max-w-full {
            max-width: 100% !important;
        }

        .fs-14 {
            font-size: 14px;
        }

        .input-group-text {
            padding-left: .375rem;
            padding-right: .375rem;
        }

        .single-item {
            display: flex;
            gap: 5px;
        }

        .single-item .input-group {
            width: 300px;
        }

        .invoice__info {
            flex-grow: 1;
            max-width: 250px;
        }

        .product-items__bottom {
            display: flex;
            flex-wrap: wrap align-items: center;
            justify-content: space-between;
            margin-bottom: 16px;
            padding-bottom: 8px;
            border-bottom: 1px solid rgba(0, 0, 0, 0.05);
            gap: 8px;
        }

        .invoice__info:not(:last-child) {
            margin-bottom: 12px;
        }

        .invoice__info-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            font-size: 14px;
        }

        .invoice__info-item .label {
            font-weight: 600;
            color: rgba(0, 0, 0, 0.5);
        }

        .invoice__info-item .value {
            font-weight: 600;
            color: rgba(0, 0, 0, 0.8);
        }

        .invoice__user-info .invoice__info:not(:last-child) {
            padding-bottom: 12px;
            border-bottom: 1px solid rgba(0, 0, 0, 0.05);
        }

        /* #total_amount.invoice__info-item {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    padding-top: 8px;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    border-top: 1px solid rgba(0, 0, 0, 0.05);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                } */

        #subtotal.invoice__info-item {
            font-size: 18px;
            padding-top: 8px;
            border-top: 1px dashed rgba(0, 0, 0, 0.15);
        }
    </style>
@endpush
