@extends($activeTemplate . 'layouts.frontend')

@section('content')

    @include($activeTemplate . 'partials.banner')

    @if ($sections->secs != null)
        @foreach (json_decode($sections->secs) as $sec)
            @include($activeTemplate . 'sections.' . $sec)
        @endforeach
    @endif
@endsection


@push('script-scroll')
    <script src="{{ asset($activeTemplateTrue . 'js/scrollTrigger.min.js') }}"></script>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";

            //========================= Scroll Trigger Js Start ======================
            (() => {
                const contentMarkers = gsap.utils.toArray(".contentMarker");
                gsap.defaults({
                    overwrite: "auto"
                });
                // Set up our scroll trigger
                const ST = ScrollTrigger.create({
                    trigger: "#features",
                    start: "top top",
                    end: "bottom bottom",
                    onUpdate: getCurrentSection,
                    pin: ".left-content",
                });


                // Set up our content behaviors
                contentMarkers.forEach((marker) => {
                    marker.content = document.querySelector(
                        `#${marker.dataset.markerContent}`
                    );
                    gsap.set(marker.content, {
                        transformOrigin: "center"
                    });
                    marker.content.enter = function() {
                        gsap.fromTo(
                            marker.content, {
                                autoAlpha: 0
                            }, {
                                duration: 0,
                                autoAlpha: 1,
                                rotateY: 0
                            }
                        );
                    };
                    marker.content.leave = function() {
                        gsap.to(marker.content, {
                            duration: 0,
                            autoAlpha: 0
                        });
                    };
                });

                // Handle the updated position
                setTimeout(() => {
                    getCurrentSection();
                }, 500);

                $('[href="#features"]').on("click", function(e) {
                    setTimeout(() => {
                        getCurrentSection();
                    }, 100);
                });
                let lastContent;

                function getCurrentSection() {
                    let newContent;
                    const currScroll = scrollY;
                    contentMarkers.forEach((marker) => {
                        if (currScroll > marker.offsetTop - 100) {
                            newContent = marker.content;
                        }
                    });
                    if (
                        newContent &&
                        (lastContent == null || !newContent.isSameNode(lastContent))
                    ) {
                        if (lastContent) {
                            lastContent.leave();
                        }
                        newContent.enter();
                        lastContent = newContent;
                    }
                }

                const media = window.matchMedia("screen and (max-width: 600px)");
                ScrollTrigger.addEventListener("refreshInit", checkSTState);

                function checkSTState() {
                    if (media.matches) {
                        ST.disable();
                    } else {
                        ST.enable();
                    }
                }
                checkSTState();
            })();
            //========================= Scroll Trigger Js End ======================


        })(jQuery);
    </script>
@endpush
