@extends($activeTemplate . 'layouts.frontend')
@php
    $contact = getContent('contact_us.content', true);
    $user = userGuard();
@endphp
@section('content')
    <section class="contact-section py-60">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="section-heading">
                        <h3 class="section-heading__title">{{ __(@$contact->data_values->heading) }}</h3>
                        <p class="section-heading__desc">{{ __(@$contact->data_values->subheading) }}</p>
                    </div>
                    <div class="contact-from">
                        <div class="row justify-content-center">
                            <div class="col-lg-6">
                                <form action="" method="POST">
                                    @csrf
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="form-group">
                                                <input type="text" class="form--control" name="name" value="{{ $user['user'] ? $user['user']->fullname : old('name') }}" placeholder="" {{ $user['user'] && $user['user']->profile_complete ? 'readonly' : 'required' }}>
                                                <label class="form--label">@lang('Name')</label>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="form-group">
                                                <input type="email" class="form--control" name="email" value="{{ $user['user'] ? $user['user']->email : old('email') }}" placeholder="" {{ $user['user'] ? 'readonly' : 'required' }}>
                                                <label class="form--label">@lang('Email Address')</label>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="form-group">
                                                <input type="text" class="form--control" name="subject" placeholder="" required>
                                                <label for="contact-name" class="form--label">@lang('Subject')</label>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="form-group">
                                                <textarea class="form--control" class="message" name="message" placeholder="" rows="20"></textarea>
                                                <label class="form--label"> @lang('Messages') <span class="text--danger">*</span></label>
                                            </div>
                                        </div>
                                        <div class="col-12" id="captcha">
                                            <x-captcha/>
                                        </div>
                                        <div class="col-12 text-center">
                                            <button type="submit" class="btn btn--base w-100 rounded-3">@lang('Contact Now')</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    @if ($sections->secs != null)
        @foreach (json_decode($sections->secs) as $sec)
            @include($activeTemplate . 'sections.' . $sec)
        @endforeach
    @endif
@endsection

@push('script')
    <script>
        "use strict";
        (function ($) {
            $("#captcha").find(`.mb-3`).addClass(`form-group`).removeClass(`mb-3`);
        })(jQuery);
        
    </script>
@endpush
