@extends($activeTemplate . 'layouts.agent_master')
@section('content')
    <div class="row justify-content-center mt-5">
        <div class="col-xl-3 col-lg-4 mb-30">
            <div class="card">
                <div class="card-body">
                    <h4 class="mb-2 text-center">{{ @$user->fullname }}</h4>
                    <ul class="list-group">
                        <li class="list-group-item d-flex justify-content-between align-items-center flex-wrap gap-1">
                            <span class="fw--bold"><i class="las la-user base--color"></i> @lang('Username')</span> <span>{{ @$user->username }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center flex-wrap gap-1">
                            <span class="fw--bold"><i class="las la-envelope base--color"></i> @lang('Email')</span> <span>[{{ $user->email }}]</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center flex-wrap gap-1">
                            <span class="fw--bold"><i class="las la-phone base--color"></i> @lang('Mobile')</span> <span>[{{ $user->mobile }}]</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center flex-wrap gap-1">
                            <span class="fw--bold"><i class="las la-globe base--color"></i> @lang('Country')</span> <span>{{ @$user->address->country }}</span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="col-xl-9 col-lg-8 mb-30">
            <div class="card style--two">
                <div class="card-header d-flex flex-wrap align-items-center justify-content-center">
                    <h5 class="card-title">@lang('Profile Setting')</h5>
                </div>
                <div class="card-body p-4">
                    <form class="register prevent-double-click" action="" method="post" enctype="multipart/form-data">
                        @csrf
                        <div class="row">
                            <div class="col-xxl-4 col-lg-6">
                                <div class="form-group">
                                    <label>@lang('Profile Image')</label>
                                    <x-image-uploader image="{{ $user->image }}" class="w-100" type="agentProfile" :required="false" />
                                </div>
                            </div>
                            <div class="col-xxl-8 col-lg-6">
                                <div class="form-group">
                                    <label for="InputFirstname" class="col-form-label">@lang('First Name')</label>
                                    <input type="text" class="form--control" id="InputFirstname" name="firstname" placeholder="@lang('First Name')" value="{{ $user->firstname }}" required>
                                </div>
                                <div class="form-group">
                                    <label for="lastname" class="col-form-label">@lang('Last Name')</label>
                                    <input type="text" class="form--control" id="lastname" name="lastname" placeholder="@lang('Last Name')" value="{{ $user->lastname }}" required>
                                </div>
                                <div class="form-group">
                                    <label for="address" class="col-form-label">@lang('Address')</label>
                                    <input type="text" class="form--control" id="address" name="address" placeholder="@lang('Address')" value="{{ @$user->address->address }}">
                                </div>
                                <div class="row">
                                    <div class="col-xxl-6">
                                        <div class="form-group">
                                            <label for="state" class="col-form-label">@lang('State')</label>
                                            <input type="text" class="form--control" id="state" name="state" placeholder="@lang('state')" value="{{ @$user->address->state }}">
                                        </div>
                                        
                                    </div>
                                    <div class="col-xxl-6">
                                        <div class="form-group">
                                            <label for="zip" class="col-form-label">@lang('Zip Code')</label>
                                            <input type="text" class="form--control" id="zip" name="zip" placeholder="@lang('Zip Code')" value="{{ @$user->address->zip }}">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="city" class="col-form-label">@lang('City')</label>
                                    <input type="text" class="form--control" id="city" name="city" placeholder="@lang('City')" value="{{ @$user->address->city }}">
                                </div>
                                <div class="form-group row mt-2">
                                    <div class="col-sm-12 text-center">
                                        <button type="submit" class="btn btn--base w-100">@lang('Submit')</button>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script')
    <script>
        (function($) {
            "use strict";

            function proPicURL(input) {
                if (input.files && input.files[0]) {
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        var preview = $(input).closest('.image-upload-wrapper').find('.image-upload-preview');
                        $(preview).css('background-image', 'url(' + e.target.result + ')');
                        $(preview).addClass('has-image');
                        $(preview).hide();
                        $(preview).fadeIn(650);
                    }
                    reader.readAsDataURL(input.files[0]);
                }
            }
            $(".image-upload-input").on('change', function() {
                proPicURL(this);
            });
            $(".remove-image").on('click', function() {
                $(this).parents(".image-upload-preview").css('background-image', 'none');
                $(this).parents(".image-upload-preview").removeClass('has-image');
                $(this).parents(".image-upload-wrapper").find('input[type=file]').val('');
            });
        })(jQuery);
    </script>
@endpush

@push('style')
    <style>
        .card {
            box-shadow: 1px 1px 9px #00000012;
        }

        .card-body {
            background-color: #fff;
        }

        .card.style--two .card-header {
            background-color: white;
        }

        .profile-disabled {
            border-left: 1px solid #dddddddb;
        }

        .list-group-item+.list-group-item span.fw-bold {
            font-size: 14px;
        }



        .image--uploader {
            width: 240px;
            border-radius: 10px;
        }

        .image-upload-wrapper {
            height: 280px;
            position: relative;
        }

        .image-upload-preview {
            width: 100%;
            height: 100%;
            display: block;
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            border-radius: 10px;
            border: 1px solid #CED4DA;
        }

        .image-upload-input-wrapper {
            position: absolute;
            display: inline-flex;
            bottom: -14px;
            right: -7px;
        }

        .image-upload-input-wrapper input {
            width: 0;
            opacity: 0;
        }

        .image-upload-input-wrapper label {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            text-align: center;
            border: 2px solid #fff;
            font-size: 18px;
            cursor: pointer;
            display: flex;
            justify-content: center;
            align-items: center;
            margin-bottom: 0;
            color: white;
        }
    </style>
@endpush
