@extends($activeTemplate . 'layouts.agent_master')

@section('content')
    <div class="card custom--card border-0 mt-5">
        <div class="card-body p-4">
            <form action="" method="POST" id="form">
                <div class="row justify-content-center">
                    <div class="col-lg-8 ">
                        @csrf
                        <div class="d-widget shadow-sm">
                            <div class="d-widget__header">
                                <h6>@lang('Cash In Detail')</h4>
                            </div>
                            <div class="d-widget__content px-5">
                                <div class="p-4 border mb-4">
                                    <div class="row">
                                        <div class="col-lg-12 form-group">
                                            <label class="mb-0">@lang('User Username/Mobile')</label>
                                            <input type="text" class="form--control checkUser" name="user"
                                                placeholder="@lang('User Username/Mobile')" required value="{{ old('user') }}">
                                        </div>
                                        <label class="exist text-end"></label>
                                    </div>
                                </div>
                                <div class="p-4 border mb-4">
                                    <div class="row">
                                        <div class="col-lg-12 form-group">
                                            <label class="mb-0">@lang('Amount')</label>
                                            <input type="number" step="any" class="form--control amount" name="amount"
                                                placeholder="@lang('Amount')" required value="{{ old('amount') }}">
                                        </div>
                                        <label>
                                            <span
                                                class="text--warning min">@lang('Min: '){{ getAmount($cashInCharge->min_limit) }}
                                                {{ __(gs('cur_text')) }} --</span>
                                            <span Walletn
                                                class="text--warning max">@lang('Max: '){{ getAmount($cashInCharge->max_limit) }}
                                                {{ __(gs('cur_text')) }}</span>
                                        </label>
                                    </div>
                                </div>

                                @include($activeTemplate . 'partials.otp_type')

                                <button type="submit"
                                    class="btn btn-md btn--base mt-4 money_in w-100">@lang('Cash In')</button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@push('script')
    <script>
        'use strict';
        (function($) {
            $('.checkUser').on('focusout', function(e) {
                $('.exist').text('')
                var url = '{{ route('agent.user.check.exist') }}';
                var value = $(this).val();
                if (!value) {
                    return 0;
                }
                var token = '{{ csrf_token() }}';
                var data = {
                    user: value,
                    _token: token
                }

                $.post(url, data, function(response) {
                    if (response['data']) {
                        if ($('.exist').hasClass('text--danger')) {
                            $('.exist').removeClass('text--danger');
                        }
                        $('.exist').text(`Valid user to cash in.`).addClass('text--success');
                    } else {
                        if ($('.exist').hasClass('text--success')) {
                            $('.exist').removeClass('text--success');
                        }
                        $('.exist').text('User not found.').addClass('text--danger');

                    }
                });
            });

            $('#form').on('submit', function(e) {
                var submitBtn = $('.money_in');
                if (submitBtn.prop('disabled')) {
                    e.preventDefault();
                    return;
                }
                submitBtn.prop('disabled', true).text('@lang('Processing...')');
            });


            var old = @json(session()->getOldInput());
            if (old.length != 0) {
                $('input[name=user]').val(old.user);
                $('input[name=amount]').val(old.amount);
            }
        })(jQuery);
    </script>
@endpush
