@extends('admin.layouts.app')

@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <div class="payment-method-item">
                        <div class="payment-method-body">
                            <div class="row">
                                <div class="col-xl-6">
                                    <div class="card border--primary mb-3">
                                        <h5 class="card-header bg--primary">@lang('Send Money')</h5>
                                        <div class="card-body">
                                            <form action="{{ route('admin.transaction.charges.update') }}" method="post">
                                                @csrf
                                                <input type="hidden" name="id" value="{{ $sendMoney->id }}">

                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        <div class="input-group has_append">
                                                            <label class="w-100">@lang('Percentage Charge') <span class="text-danger">*</span></label>
                                                            <input type="number" step="any" class="form-control" name="percentage_charge" placeholder="0" value="{{ getAmount($sendMoney->percent_charge, 2) }}" />
                                                            <div class="input-group-text">%</div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-6 mb-3">
                                                        <div class="input-group has_append">
                                                            <label class="w-100">@lang('Fixed Charge') <span class="text-danger">*</span></label>
                                                            <input type="number" step="any" class="form-control" name="fixed_charge" placeholder="0" value="{{ getAmount($sendMoney->fixed_charge, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-6 mb-3">
                                                        <div class="input-group has_append">
                                                            <label class="w-100">@lang('Minimum Amount') <span class="text-danger">*</span></label>
                                                            <input type="number" step="any" class="form-control" name="min_limit" placeholder="0" value="{{ getAmount($sendMoney->min_limit, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-6 mb-3">
                                                        <div class="input-group has_append">
                                                            <label class="w-100">@lang('Maximum Amount') <span class="text-danger">*</span></label>
                                                            <input type="number" step="any" class="form-control" name="max_limit" placeholder="0" value="{{ getAmount($sendMoney->max_limit, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-6 mb-3">
                                                        <label class="w-100">@lang('Daily Transfer Limit') <span class="text-danger">*</span></label>
                                                        <div class="input-group has_append">
                                                            <input type="number" step="any" class="form-control" name="daily_limit" placeholder="0" value="{{ getAmount($sendMoney->daily_limit, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                        <code class="text--info"><i class="las la-exclamation-circle me-1"></i>@lang('Put -1 if you don\'t want limit')</code>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <label class="w-100">@lang('Daily Request Accept Limit') <span class="text-danger">*</span></label>
                                                        <div class="input-group has_append">
                                                            <input type="number" step="any" class="form-control" name="daily_request_accept_limit" placeholder="0" value="{{ getAmount($sendMoney->daily_request_accept_limit, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                        <code class="text--info"><i class="las la-exclamation-circle me-1"></i>@lang('Put -1 for unlimited')</code>
                                                    </div>


                                                    <div class="col-md-6 mb-3">
                                                        <label class="w-100">@lang('Monthly Send Money Limit') <span class="text-danger">*</span></label>
                                                        <div class="input-group has_append">
                                                            <input type="number" step="any" class="form-control" name="monthly_limit" placeholder="0" value="{{ getAmount($sendMoney->monthly_limit, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                        <code class="text--info"><i class="las la-exclamation-circle me-1"></i>@lang('Put -1 if you don\'t want limit')</code>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <label class="w-100">@lang('Monthly Request Accept Limit') <span class="text-danger">*</span></label>
                                                        <div class="input-group has_append">
                                                            <input type="number" step="any" class="form-control" name="monthly_request_accept_limit" placeholder="0" value="{{ getAmount($sendMoney->monthly_request_accept_limit, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                        <code class="text--info"><i class="las la-exclamation-circle me-1"></i>@lang('Put -1 if you don\'t want limit')</code>
                                                    </div>

                                                    <div class="col-md-6 mb-3">
                                                        <label class="w-100">@lang('Referral Percentage Commission') <span class="text-danger">*</span></label>
                                                        <div class="input-group has_append">
                                                            <input type="number" step="any" class="form-control" name="referral_percentage_commission" placeholder="0" value="{{ getAmount($sendMoney->referral_percentage_commission, 2) }}" />
                                                            <div class="input-group-text"> % </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <label class="w-100">@lang('Referral Fixed Commission') <span class="text-danger">*</span></label>
                                                        <div class="input-group has_append">
                                                            <input type="number" step="any" class="form-control" name="referral_fixed_commission" placeholder="0" value="{{ getAmount($sendMoney->referral_fixed_commission, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-12 mb-3">
                                                        <label class="w-100">@lang('Maximum Charge Cap') <span class="text-danger">*</span></label>
                                                        <div class="input-group has_append">
                                                            <input type="number" step="any" class="form-control" name="cap" placeholder="0" value="{{ getAmount($sendMoney->cap) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                        <code class="text--info"><i class="las la-exclamation-circle me-1"></i>@lang('Put -1 if you don\'t want charge cap')</code>
                                                    </div>
                                                </div>
                                                <button type="submit" class="btn btn--primary w-100 h-45 mt-2">@lang('Submit')</button>
                                            </form>
                                        </div>
                                    </div>


                                    <div class="card border--primary mb-3">
                                        <h5 class="card-header bg--primary">@lang('Cash In')</h5>
                                        <div class="card-body">
                                            <form action="{{ route('admin.transaction.charges.update') }}" method="post">
                                                @csrf
                                                <input type="hidden" name="id" value="{{ $cashInCharge->id }}">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="input-group has_append mb-3">
                                                            <label class="w-100">@lang('Minimum Amount') <span class="text-danger">*</span></label>
                                                            <input type="number" step="any" class="form-control" name="min_limit" placeholder="0" value="{{ getAmount($cashInCharge->min_limit, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="input-group has_append mb-3">
                                                            <label class="w-100">@lang('Maximum Amount') <span class="text-danger">*</span></label>
                                                            <input type="number" step="any" class="form-control" name="max_limit" placeholder="0" value="{{ getAmount($cashInCharge->max_limit, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="input-group has_append mb-3">
                                                            <label class="w-100">@lang('Agent Commission (fixed)') <span class="text-danger">*</span></label>
                                                            <input type="number" step="any" class="form-control" name="agent_com_fixed" placeholder="0" value="{{ getAmount($cashInCharge->agent_commission_fixed, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="input-group has_append mb-3">
                                                            <label class="w-100">@lang('Agent Commission (%)') <span class="text-danger">*</span></label>
                                                            <input type="number" step="any" class="form-control" name="agent_com_percent" placeholder="0" value="{{ getAmount($cashInCharge->agent_commission_percent, 2) }}" />
                                                            <div class="input-group-text">%</div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <div class="input-group has_append">
                                                            <label class="w-100">@lang('Daily Money In Limit') <span class="text-danger">*</span></label>
                                                            <input type="number" step="any" class="form-control" name="daily_limit" placeholder="0" value="{{ getAmount($cashInCharge->daily_limit, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                        <code class="text--info"><i class="las la-exclamation-circle me-1"></i>@lang('Put -1 if you don\'t want limit')</code>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <label class="w-100">@lang('Monthly Money In Limit') <span class="text-danger">*</span></label>
                                                        <div class="input-group has_append">
                                                            <input type="number" step="any" class="form-control" name="monthly_limit" placeholder="0" value="{{ getAmount($cashInCharge->monthly_limit, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                        <code class="text--info"><i class="las la-exclamation-circle me-1"></i>@lang('Put -1 if you don\'t want limit')</code>
                                                    </div>
                                                </div>
                                                <button type="submit" class="btn btn--primary w-100 h-45 mt-2">@lang('Submit')</button>
                                            </form>
                                        </div>
                                    </div>

                                    <div class="card border--primary mb-3">
                                        <h5 class="card-header bg--primary">@lang('Cash Out')</h5>
                                        <div class="card-body">
                                            <form action="{{ route('admin.transaction.charges.update') }}" method="post">
                                                @csrf
                                                <input type="hidden" name="id" value="{{ $cashOutCharge->id }}">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="input-group has_append mb-3">
                                                            <label class="w-100">@lang('Percentage Charge') <span class="text-danger">*</span></label>
                                                            <input type="number" step="any" class="form-control" name="percentage_charge" placeholder="0" value="{{ getAmount($cashOutCharge->percent_charge, 2) }}" />
                                                            <div class="input-group-text">%</div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="input-group has_append mb-3">
                                                            <label class="w-100">@lang('Fixed Charge') <span class="text-danger">*</span></label>
                                                            <input type="number" step="any" class="form-control" name="fixed_charge" placeholder="0" value="{{ getAmount($cashOutCharge->fixed_charge, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-6">
                                                        <div class="input-group has_append mb-3">
                                                            <label class="w-100">@lang('Minimum Amount') <span class="text-danger">*</span></label>
                                                            <input type="number" step="any" class="form-control" name="min_limit" placeholder="0" value="{{ getAmount($cashOutCharge->min_limit, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="input-group has_append mb-3">
                                                            <label class="w-100">@lang('Maximum Amount') <span class="text-danger">*</span></label>
                                                            <input type="number" step="any" class="form-control" name="max_limit" placeholder="0" value="{{ getAmount($cashOutCharge->max_limit, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-6">
                                                        <label class="w-100">@lang('Agent Commission (fixed)') <span class="text-danger">*</span></label>
                                                        <div class="input-group has_append mb-3">
                                                            <input type="number" step="any" class="form-control" name="agent_com_fixed" placeholder="0" value="{{ getAmount($cashOutCharge->agent_commission_fixed, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="input-group has_append mb-3">
                                                            <label class="w-100">@lang('Agent Commission (%)') <span class="text-danger">*</span></label>
                                                            <input type="number" step="any" class="form-control" name="agent_com_percent" placeholder="0" value="{{ getAmount($cashOutCharge->agent_commission_percent, 2) }}" />
                                                            <div class="input-group-text">%</div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <label class="w-100 mb-0">@lang('Daily Cash Out Limit') <span class="text-danger">*</span></label>
                                                        <div class="input-group has_append">
                                                            <input type="number" step="any" class="form-control" name="daily_limit" placeholder="0" value="{{ getAmount($cashOutCharge->daily_limit, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                        <code class="text--info"><i class="las la-exclamation-circle me-1"></i>@lang('Put -1 if you don\'t want limit')</code>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <label class="w-100 mb-0">@lang('Monthly Cash Out Limit') <span class="text-danger">*</span></label>
                                                        <div class="input-group has_append">
                                                            <input type="number" step="any" class="form-control" name="monthly_limit" placeholder="0" value="{{ getAmount($cashOutCharge->monthly_limit, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                        <code class="text--info"><i class="las la-exclamation-circle me-1"></i>@lang('Put -1 if you don\'t want limit')</code>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <label class="w-100">@lang('Referral Percentage Commission') <span class="text-danger">*</span></label>
                                                        <div class="input-group has_append">
                                                            <input type="number" step="any" class="form-control" name="referral_percentage_commission" placeholder="0" value="{{ getAmount($cashOutCharge->referral_percentage_commission, 2) }}" />
                                                            <div class="input-group-text"> % </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <label class="w-100">@lang('Referral Fixed Commission') <span class="text-danger">*</span></label>
                                                        <div class="input-group has_append">
                                                            <input type="number" step="any" class="form-control" name="referral_fixed_commission" placeholder="0" value="{{ getAmount($cashOutCharge->referral_fixed_commission, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <button type="submit" class="btn btn--primary w-100 h-45 mt-2">@lang('Submit')</button>
                                            </form>
                                        </div>
                                    </div>

                                    <div class="card border--primary mb-3">
                                        <h5 class="card-header bg--primary">@lang('Mobile Recharge')</h5>
                                        <div class="card-body">
                                            <form action="{{ route('admin.transaction.charges.update') }}" method="post">
                                                @csrf
                                                <input type="hidden" name="id" value="{{ $mobileRecharge->id }}">
                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        <label class="w-100">@lang('Percentage Charge') <span class="text-danger">*</span></label>
                                                        <div class="input-group has_append">
                                                            <input type="number" step="any" class="form-control" name="percentage_charge" placeholder="0" value="{{ getAmount($mobileRecharge->percent_charge, 2) }}" />
                                                            <div class="input-group-text">%</div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <div class="input-group has_append">
                                                            <label class="w-100">@lang('Fixed Charge') <span class="text-danger">*</span></label>
                                                            <input type="number" step="any" class="form-control" name="fixed_charge" placeholder="0" value="{{ getAmount($mobileRecharge->fixed_charge, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <div class="input-group has_append">
                                                            <label class="w-100">@lang('Minimum Amount') <span class="text-danger">*</span></label>
                                                            <input type="number" step="any" class="form-control" name="min_limit" placeholder="0" value="{{ getAmount($mobileRecharge->min_limit, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <div class="input-group has_append mb-3">
                                                            <label class="w-100">@lang('Maximum Amount') <span class="text-danger">*</span></label>
                                                            <input type="number" step="any" class="form-control" name="max_limit" placeholder="0" value="{{ getAmount($mobileRecharge->max_limit, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <label class="w-100">@lang('Referral Percentage Commission') <span class="text-danger">*</span></label>
                                                        <div class="input-group has_append">
                                                            <input type="number" step="any" class="form-control" name="referral_percentage_commission" placeholder="0" value="{{ getAmount($mobileRecharge->referral_percentage_commission, 2) }}" />
                                                            <div class="input-group-text"> % </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <label class="w-100">@lang('Referral Fixed Commission') <span class="text-danger">*</span></label>
                                                        <div class="input-group has_append">
                                                            <input type="number" step="any" class="form-control" name="referral_fixed_commission" placeholder="0" value="{{ getAmount($mobileRecharge->referral_fixed_commission, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <button type="submit" class="btn btn--primary w-100 h-45 mt-2">@lang('Submit')</button>
                                            </form>
                                        </div>
                                    </div>

                                </div>





                                <div class="col-xl-6">


                                    <div class="card border--primary mb-3">
                                        <h5 class="card-header bg--primary">@lang('Bank Transfer')</h5>
                                        <div class="card-body">
                                            <form action="{{ route('admin.transaction.charges.update') }}" method="post">
                                                @csrf
                                                <input type="hidden" name="id" value="{{ $bankTransfer->id }}">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="input-group has_append mb-3">
                                                            <label class="w-100">@lang('Percentage Charge') <span class="text-danger">*</span></label>
                                                            <input type="number" step="any" class="form-control" name="percentage_charge" placeholder="0" value="{{ getAmount($bankTransfer->percent_charge, 2) }}" />
                                                            <div class="input-group-text">%</div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="input-group has_append mb-3">
                                                            <label class="w-100">@lang('Fixed Charge') <span class="text-danger">*</span></label>
                                                            <input type="number" step="any" class="form-control" name="fixed_charge" placeholder="0" value="{{ getAmount($bankTransfer->fixed_charge, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="input-group has_append mb-3">
                                                            <label class="w-100">@lang('Minimum Amount') <span class="text-danger">*</span></label>
                                                            <input type="number" step="any" class="form-control" name="min_limit" placeholder="0" value="{{ getAmount($bankTransfer->min_limit, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="input-group has_append mb-3">
                                                            <label class="w-100">@lang('Maximum Amount') <span class="text-danger">*</span></label>
                                                            <input type="number" step="any" class="form-control" name="max_limit" placeholder="0" value="{{ getAmount($bankTransfer->max_limit, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-6 mb-3">
                                                        <label class="w-100">@lang('Daily Bank Transfer Limit') <span class="text-danger">*</span> </label>
                                                        <div class="input-group has_append">
                                                            <input type="number" step="any" class="form-control" name="daily_limit" placeholder="0" value="{{ getAmount($bankTransfer->daily_limit, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                        <code class="text--info"><i class="las la-exclamation-circle me-1"></i>@lang('Put -1 if you don\'t want limit')</code>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <div class="input-group has_append">
                                                            <label class="w-100">@lang('Monthly Bank Transfer Limit')<span class="text-danger">*</span></label>
                                                            <input type="number" step="any" class="form-control" name="monthly_limit" placeholder="0" value="{{ getAmount($bankTransfer->monthly_limit, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                        <code class="text--info"><i class="las la-exclamation-circle me-1"></i>@lang('Put -1 if you don\'t want limit')</code>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <label class="w-100">@lang('Referral Percentage Commission') <span class="text-danger">*</span></label>
                                                        <div class="input-group has_append">
                                                            <input type="number" step="any" class="form-control" name="referral_percentage_commission" placeholder="0" value="{{ getAmount($bankTransfer->referral_percentage_commission, 2) }}" />
                                                            <div class="input-group-text"> % </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <label class="w-100">@lang('Referral Fixed Commission') <span class="text-danger">*</span></label>
                                                        <div class="input-group has_append">
                                                            <input type="number" step="any" class="form-control" name="referral_fixed_commission" placeholder="0" value="{{ getAmount($bankTransfer->referral_fixed_commission, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <button type="submit" class="btn btn--primary w-100 h-45 mt-2">@lang('Submit')</button>
                                            </form>
                                        </div>
                                    </div>

                                    <div class="card border--primary mb-3">
                                        <h5 class="card-header bg--primary">@lang('Payment Charges')</h5>
                                        <div class="card-body">
                                            <form action="{{ route('admin.transaction.charges.update') }}" method="post">
                                                @csrf
                                                <input type="hidden" name="id" value="{{ $paymentCharge->id }}">
                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        <div class="input-group has_append">
                                                            <label class="w-100">@lang('Merchant percent charge') <span class="text-danger">*</span></label>
                                                            <input type="number" step="any" class="form-control" name="merchant_payment_percent_charge" placeholder="0" value="{{ getAmount($paymentCharge->merchant_payment_percent_charge, 2) }}" />
                                                            <div class="input-group-text">%</div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <div class="input-group has_append">
                                                            <label class="w-100">@lang('Merchant fixed charge') <span class="text-danger">*</span></label>
                                                            <input type="number" step="any" class="form-control" name="merchant_payment_fixed_charge" placeholder="0" value="{{ getAmount($paymentCharge->merchant_payment_fixed_charge, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <div class="input-group has_append">
                                                            <label class="w-100">@lang('User percent charge') <span class="text-danger">*</span></label>
                                                            <input type="number" step="any" class="form-control" name="user_payment_percent_charge" placeholder="0" value="{{ getAmount($paymentCharge->user_payment_percent_charge, 2) }}" />
                                                            <div class="input-group-text">%</div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <div class="input-group has_append">
                                                            <label class="w-100">@lang('User fixed charge') <span class="text-danger">*</span></label>
                                                            <input type="number" step="any" class="form-control" name="user_payment_fixed_charge" placeholder="0" value="{{ getAmount($paymentCharge->user_payment_fixed_charge, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12 mb-3">
                                                        <div class="input-group has_append">
                                                            <label class="w-100">@lang('Payment Maximum Charge Cap') <span class="text-danger">*</span></label>
                                                            <input type="number" step="any" class="form-control" name="cap" placeholder="0" value="{{ getAmount($paymentCharge->cap, 2) }}" />
                                                            <div class="input-group-text">{{ gs('cur_text') }}</div>
                                                        </div>
                                                        <code class="text--info"><i class="las la-exclamation-circle me-1"></i>@lang('Put -1 if you don\'t want charge cap')</code>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <label class="w-100">@lang('Referral Percentage Commission') <span class="text-danger">*</span></label>
                                                        <div class="input-group has_append">
                                                            <input type="number" step="any" class="form-control" name="referral_percentage_commission" placeholder="0" value="{{ getAmount($paymentCharge->referral_percentage_commission, 2) }}" />
                                                            <div class="input-group-text"> % </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <label class="w-100">@lang('Referral Fixed Commission') <span class="text-danger">*</span></label>
                                                        <div class="input-group has_append">
                                                            <input type="number" step="any" class="form-control" name="referral_fixed_commission" placeholder="0" value="{{ getAmount($paymentCharge->referral_fixed_commission, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <button type="submit" class="btn btn--primary w-100 h-45 mt-2">@lang('Submit')</button>
                                            </form>
                                        </div>
                                    </div>
                                    <div class="card border--primary mb-3">
                                        <h5 class="card-header bg--primary">@lang('Voucher Create Charge')</h5>
                                        <div class="card-body">
                                            <form action="{{ route('admin.transaction.charges.update') }}" method="post">
                                                @csrf
                                                <input type="hidden" name="id" value="{{ $voucherCharge->id }}">
                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        <label class="w-100">@lang('Percentage Charge') <span class="text-danger">*</span></label>
                                                        <div class="input-group has_append">
                                                            <input type="number" step="any" class="form-control" name="percentage_charge" placeholder="0" value="{{ getAmount($voucherCharge->percent_charge, 2) }}" />
                                                            <div class="input-group-text">%</div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <label class="w-100">@lang('Fixed Charge') <span class="text-danger">*</span></label>
                                                        <div class="input-group has_append">
                                                            <input type="number" step="any" class="form-control" name="fixed_charge" placeholder="0" value="{{ getAmount($voucherCharge->fixed_charge, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <label class="w-100">@lang('Minimum Amount') <span class="text-danger">*</span></label>
                                                        <div class="input-group has_append">
                                                            <input type="number" step="any" class="form-control" name="min_limit" placeholder="0" value="{{ getAmount($voucherCharge->min_limit, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <label class="w-100">@lang('Maximum Amount') <span class="text-danger">*</span></label>
                                                        <div class="input-group has_append">
                                                            <input type="number" step="any" class="form-control" name="max_limit" placeholder="0" value="{{ getAmount($voucherCharge->max_limit, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <div class="input-group has_append">
                                                            <label class="w-100">@lang('Daily Voucher Create Limit') <span class="text-danger">*</span> </label>
                                                            <input type="number" step="any" class="form-control" name="voucher_limit" placeholder="0" value="{{ getAmount($voucherCharge->voucher_limit) }}" />
                                                        </div>
                                                        <code class="text--info"><i class="las la-exclamation-circle me-1"></i>@lang('Put -1 if you don\'t want limit')</code>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <label class="w-100">@lang('Maximum Charge Cap') <span class="text-danger">*</span></label>
                                                        <div class="input-group has_append">
                                                            <input type="number" step="any" class="form-control" name="cap" placeholder="0" value="{{ getAmount($voucherCharge->cap, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                        <code class="text--info"><i class="las la-exclamation-circle me-1"></i>@lang('Put -1 if you don\'t want charge cap')</code>
                                                    </div>
                                                </div>
                                                <button type="submit" class="btn btn--primary w-100 h-45 mt-2">@lang('Submit')</button>
                                            </form>
                                        </div>
                                    </div>

                                    <div class="card border--primary mb-3">
                                        <h5 class="card-header bg--primary">@lang('Api Payment Charge')</h5>
                                        <div class="card-body">
                                            <form action="{{ route('admin.transaction.charges.update') }}" method="post">
                                                @csrf
                                                <input type="hidden" name="id" value="{{ $apiCharge->id }}">
                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        <label class="w-100">@lang('Percentage Charge') <span class="text-danger">*</span></label>
                                                        <div class="input-group has_append">
                                                            <input type="number" step="any" class="form-control" name="percentage_charge" placeholder="0" value="{{ getAmount($apiCharge->percent_charge, 2) }}" />
                                                            <div class="input-group-text">%</div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <label class="w-100">@lang('Fixed Charge') <span class="text-danger">*</span></label>
                                                        <div class="input-group has_append">
                                                            <input type="number" step="any" class="form-control" name="fixed_charge" placeholder="0" value="{{ getAmount($apiCharge->fixed_charge, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-12 mb-3">
                                                        <div class="input-group has_append">
                                                            <label class="w-100">@lang('Maximum Charge Cap') <span class="text-danger">*</span> </label>
                                                            <input type="number" step="any" class="form-control" name="cap" placeholder="0" value="{{ getAmount($apiCharge->cap, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                        <code class="text--info"><i class="las la-exclamation-circle me-1"></i>@lang('(Put -1 if you don\'t want charge cap)')</code>
                                                    </div>
                                                </div>
                                                <button type="submit" class="btn btn--primary w-100 h-45 mt-2">@lang('Submit')</button>
                                            </form>
                                        </div>
                                    </div>

                                    <div class="card border--primary mb-3">
                                        <h5 class="card-header bg--primary">@lang('Airtime Charge')</h5>
                                        <div class="card-body">
                                            <form action="{{ route('admin.transaction.charges.update') }}" method="post">
                                                @csrf
                                                <input type="hidden" name="id" value="{{ $airtimeCharge->id }}">
                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        <label class="w-100">@lang('Percentage Charge') <span class="text-danger">*</span></label>
                                                        <div class="input-group has_append">
                                                            <input type="number" step="any" class="form-control" name="percentage_charge" placeholder="0" value="{{ getAmount($airtimeCharge->percent_charge, 2) }}" />
                                                            <div class="input-group-text">%</div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <label class="w-100">@lang('Fixed Charge') <span class="text-danger">*</span></label>
                                                        <div class="input-group has_append">
                                                            <input type="number" step="any" class="form-control" name="fixed_charge" placeholder="0" value="{{ getAmount($airtimeCharge->fixed_charge, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-12 mb-3">
                                                        <div class="input-group has_append">
                                                            <label class="w-100">@lang('Maximum Charge Cap') <span class="text-danger">*</span> </label>
                                                            <input type="number" step="any" class="form-control" name="cap" placeholder="0" value="{{ getAmount($airtimeCharge->cap, 2) }}" />
                                                            <div class="input-group-text"> {{ gs('cur_text') }} </div>
                                                        </div>
                                                        <code class="text--info"><i class="las la-exclamation-circle me-1"></i>@lang('(Put -1 if you don\'t want charge cap)')</code>
                                                    </div>
                                                </div>
                                                <button type="submit" class="btn btn--primary w-100 h-45 mt-2">@lang('Submit')</button>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div><!-- card end -->
        </div>
    </div>
@endsection

@push('style')
    <style>
        .card[class*="border"] {
            border: 1px solid;
        }

        code {
            font-size: 13px;
        }
    </style>
@endpush
