@extends('admin.layouts.app')

@section('panel')
    <div class="row mb-none-30">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header bg--primary d-flex justify-content-between">
                    <h5 class="text-white">@lang('Utility Bill Form')</h5>
                    <button type="button" class="btn btn-sm btn-outline-light float-end form-generate-btn"> <i class="la la-fw la-plus"></i>@lang('Add New')</button>
                </div>
                <form method="POST">
                    @csrf
                    <div class="card-body">
                        <input type="hidden" name="id" value="{{ $utility->id }}" required>
                        @php
                            $form = @$utility->form;
                        @endphp

                        <x-generated-form :form="@$form" />
                        
                        <button type="submit" class="btn btn--primary w-100 h-45">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <x-form-generator-modal />
@endsection

@push('breadcrumb-plugins')
    <x-back route="{{ route('admin.setup.utility.bill.all') }}" />
@endpush
