@extends('admin.layouts.app')

@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 bg--transparent shadow-none">
                <div class="card-body p-0">
                    <div class="table-responsive--lg table-responsive">
                        <table class="table--light style--two table bg-white">
                            <thead>
                                <tr>
                                    <th>@lang('Name')</th>
                                    <th>@lang('Fixed Charge')</th>
                                    <th>@lang('Percent Charge')</th>
                                    <th>@lang('Configured')</th>
                                    <th>@lang('Auto Payment')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($utilityBills as $utility)
                                    <tr>
                                        <td>
                                            <span class="fw-bold">{{ __($utility->name) }}</span>
                                        </td>
                                        <td>{{ showAmount($utility->fixed_charge) }}</td>
                                        <td>{{ showAmount($utility->percent_charge, currencyFormat: false) }}%</td>
                                        <td>
                                            @if ($utility->form)
                                                <span class="badge badge--success">@lang('Yes')</span>
                                            @else
                                                <span class="badge badge--warning">@lang('No')</span>
                                            @endif
                                        </td>
                                        <td>
                                            @php echo $utility->autoPaymentBadge; @endphp
                                        </td>
                                        <td>
                                            @php echo $utility->statusBadge; @endphp
                                        </td>
                                        <td>
                                            <div class="button--group">
                                                <button class="btn btn-sm btn-outline--primary editBtn" data-auto_payment="{{ $utility->auto_payment }}" data-id="{{ $utility->id }}" data-name="{{ $utility->name }}" data-fixed_charge="{{ getAmount($utility->fixed_charge) }}" data-percent_charge="{{ getAmount($utility->percent_charge) }}" data-image="{{ getImage(getFilePath('setup_utility') . '/' . $utility->image, getFileSize('setup_utility')) }}">
                                                    <i class="la la-pencil"></i>@lang('Edit')
                                                </button>

                                                <a href="{{ route('admin.setup.utility.bill.configure', $utility->id) }}" class="btn btn-sm btn-outline--info">
                                                    <i class="las la-cogs"></i>@lang('Configure')
                                                </a>

                                                @if ($utility->status == Status::DISABLE)
                                                    <button class="btn btn-sm btn-outline--success ms-1 confirmationBtn" data-question="@lang('Are you sure to enable this utility bill?')" data-action="{{ route('admin.setup.utility.bill.status', $utility->id) }}">
                                                        <i class="la la-eye"></i>@lang('Enable')
                                                    </button>
                                                @else
                                                    <button class="btn btn-sm btn-outline--danger ms-1 confirmationBtn" data-question="@lang('Are you sure to disable this utility bill?')" data-action="{{ route('admin.setup.utility.bill.status', $utility->id) }}">
                                                        <i class="la la-eye-slash"></i>@lang('Disable')
                                                    </button>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                @if ($utilityBills->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($utilityBills) }}
                    </div>
                @endif
            </div>
        </div>
    </div>

    <div id="utilityBillModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form action="" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Image')</label>
                                    <x-image-uploader class="w-100" type="setup_utility" />
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Name')</label>
                                    <input type="text" name="name" class="form-control" required>
                                </div>
                                <div class="form-group">
                                    <label>@lang('Fixed Charge')</label>
                                    <div class="input-group">
                                        <input type="number" step="any" name="fixed_charge" class="form-control" required>
                                        <span class="input-group-text">{{ __(gs('cur_text')) }}</span>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label>@lang('Percent Charge')</label>
                                    <div class="input-group">
                                        <input type="number" step="any" name="percent_charge" class="form-control" required>
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>

                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" id="autopayment" name="auto_payment">
                                    <label for="autopayment">@lang('Support Autopayment')</label>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--primary h-45 w-100">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <x-confirmation-modal />
@endsection

@push('breadcrumb-plugins')
    <x-search-form />
    <button class="btn btn-sm btn-outline--primary addBtn">
        <i class="las la-plus"></i>@lang('Add New')
    </button>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";
            let modal = $('#utilityBillModal');
            let action = `{{ route('admin.setup.utility.bill.save') }}`;
            let defaultImage = `{{ getImage(getFilePath('setup_utility'), getFileSize('setup_utility')) }}`;

            $('.addBtn').on('click', function() {
                modal.find('[name=auto_payment]').attr('checked', false);
                modal.find('.modal-title').text(`@lang('Setup New Utility Bill')`);
                modal.find('.image-upload-preview ').css('background-image', `url(${defaultImage}`);
                modal.find('[name=image]').attr('required', true).closest('.form-group').find('label:first').addClass('required');;
                modal.find('form').attr('action', action);
                modal.modal('show');
            });

            $('.editBtn').on('click', function() {
                let data = $(this).data();
                let authPayment = data.auto_payment ? true : false;

                modal.find('.modal-title').text(`@lang('Update Utility Bill Setup')`);
                modal.find('[name=name]').val(data.name);
                modal.find('[name=fixed_charge]').val(data.fixed_charge);
                modal.find('[name=percent_charge]').val(data.percent_charge);
                modal.find('[name=auto_payment]').attr('checked', authPayment);
                modal.find('.image-upload-preview ').css('background-image', `url(${$(this).data('image')})`);
                modal.find('[name=image]').attr('required', false).closest('.form-group').find('label:first').removeClass('required');
                modal.find('form').attr('action', `${action}/${data.id}`);
                modal.modal('show');
            });

            modal.on('hidden.bs.modal', function() {
                modal.find('form')[0].reset();
            });

        })(jQuery);
    </script>
@endpush
