@extends('admin.layouts.app')

@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 bg--transparent shadow-none">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table--light style--two table bg-white">
                            <thead>
                                <tr>
                                    <th>@lang('Name')</th>
                                    <th>@lang('Configured')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($banks as $bank)
                                    <tr>
                                        <td>
                                            <span class="fw-bold">{{ __($bank->name) }}</span>
                                        </td>
                                        <td>
                                            @if ($bank->form)
                                                <span class="badge badge--success">@lang('Yes')</span>
                                            @else
                                                <span class="badge badge--warning">@lang('No')</span>
                                            @endif
                                        </td>
                                        <td>
                                            @php echo $bank->statusBadge; @endphp
                                        </td>
                                        <td>
                                            <div class="button--group">
                                                <button class="btn btn-sm btn-outline--primary editBtn" data-id="{{ $bank->id }}" data-name="{{ $bank->name }}" data-image="{{ getImage(getFilePath('setup_bank') . '/' . $bank->image, getFileSize('setup_bank')) }}">
                                                    <i class="la la-pencil"></i> @lang('Edit')
                                                </button>

                                                <a href="{{ route('admin.setup.bank.transfer.configure', $bank->id) }}" class="btn btn-sm btn-outline--info">
                                                    <i class="las la-cogs"></i>@lang('Configure')
                                                </a>

                                                @if ($bank->status == Status::DISABLE)
                                                    <button class="btn btn-sm btn-outline--success ms-1 confirmationBtn" data-question="@lang('Are you sure to enable this record?')" data-action="{{ route('admin.setup.bank.transfer.status', $bank->id) }}">
                                                        <i class="la la-eye"></i> @lang('Enable')
                                                    </button>
                                                @else
                                                    <button class="btn btn-sm btn-outline--danger ms-1 confirmationBtn" data-question="@lang('Are you sure to disable this record?')" data-action="{{ route('admin.setup.bank.transfer.status', $bank->id) }}">
                                                        <i class="la la-eye-slash"></i> @lang('Disable')
                                                    </button>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                @if ($banks->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($banks) }}
                    </div>
                @endif
            </div>
        </div>
    </div>

    <div id="setupBankModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form action="" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <label>@lang('Name')</label>
                            <input type="text" name="name" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label>@lang('Image')</label>
                            <x-image-uploader class="w-100" type="setup_bank" />
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--primary h-45 w-100">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <x-confirmation-modal />
@endsection

@push('breadcrumb-plugins')
    <x-search-form />
    <button class="btn btn-sm btn-outline--primary addBtn">
        <i class="las la-plus"></i>@lang('Add New')
    </button>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";
            let modal = $('#setupBankModal');
            let action = `{{ route('admin.setup.bank.transfer.save') }}`;
            let defaultImage = `{{ getImage(getFilePath('setup_bank'), getFileSize('setup_bank')) }}`;

            $('.addBtn').on('click', function() {
                modal.find('.modal-title').text(`@lang('Setup New Bank Transfer')`);
                modal.find('[name=name]').val('');
                modal.find('.image-upload-preview ').css('background-image', `url(${defaultImage}`);
                modal.find('[name=image]').attr('required', true).closest('.form-group').find('label:first').addClass('required');;
                modal.find('form').attr('action', action);
                modal.modal('show');
            });

            $('.editBtn').on('click', function() {
                let data = $(this).data()
                modal.find('.modal-title').text(`@lang('Update Bank Transfer Setup')`);
                modal.find('[name=name]').val(data.name);
                modal.find('.image-upload-preview ').css('background-image', `url(${$(this).data('image')})`);
                modal.find('[name=image]').attr('required', false).closest('.form-group').find('label:first').removeClass('required');
                modal.find('form').attr('action', `${action}/${data.id}`);
                modal.modal('show');
            });

        })(jQuery);
    </script>
@endpush
