@extends('admin.layouts.app')

@section('panel')
    @push('topBar')
        @include('admin.savings.top_bar')
    @endpush

    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table table--light">
                            <thead>
                                <tr>
                                    <th>@lang('Name')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($organizations as $item)
                                    @php
                                        $item->image_with_path = getImage(
                                            getFilePath('org') . '/' . $item->image,
                                            getFileSize('org'),
                                        );
                                    @endphp
                                    <tr>
                                        <td>
                                            <div class="user thumb">
                                                <div class="thumb w-100">
                                                    <img src="{{ $item->image_with_path }}">
                                                    <span> {{ $item->name }}</span>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            @php echo $item->statusBadge; @endphp
                                        </td>

                                        <td>
                                            <div class="button--group">
                                                <button type="button" class="btn btn-sm btn-outline--primary cuModalBtn"
                                                    data-resource="{{ $item }}"
                                                    data-modal_title="@lang('Update Organization')"><i
                                                        class="las la-pencil-alt"></i>@lang('Edit')</button>

                                                <a href="{{ route('admin.savings.org.dps.plans', $item->id) }}"
                                                    class="btn btn-sm btn-outline--dark"><i
                                                        class="las la-book-open"></i>@lang('DPS Plans')</a>

                                                @if ($item->status == Status::ENABLE)
                                                    <button type="button"
                                                        class="btn btn-sm btn-outline--danger confirmationBtn"
                                                        data-question="@lang('Are you sure to disable this organization?')"
                                                        data-action="{{ route('admin.savings.org.status', $item->id) }}"><i
                                                            class="las la-eye-slash"></i>@lang('Disable')</button>
                                                @else
                                                    <button type="button"
                                                        class="btn btn-sm btn-outline--success confirmationBtn"
                                                        data-question="@lang('Are you sure to enable this organization?')"
                                                        data-action="{{ route('admin.savings.org.status', $item->id) }}"><i
                                                            class="las la-eye-slash"></i>@lang('Enable')</button>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
                @if ($organizations->hasPages())
                    <div class="card-footer">
                        {{ paginateLinks($organizations) }}
                    </div>
                @endif
            </div>
        </div>
    </div>

    <div id="cuModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form method="POST" action="{{ route('admin.savings.org.add') }}" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <label>@lang('Image')</label>
                            <x-image-uploader name="image" type="org" class="w-100" :required="false" />
                        </div>
                        <div class="form-group">
                            <label>@lang('Name')</label>
                            <input type="text" class="form-control" name="name" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--primary w-100 h-45">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <x-confirmation-modal />
@endsection

@push('breadcrumb-plugins')
    <button type="button" class="btn btn-outline--primary cuModalBtn"
        data-default_image="{{ getImage(null, getFileSize('org')) }}" data-modal_title="@lang('Add New Organization')"><i
            class="las la-plus"></i>@lang('Add New')</button>
    <x-search-form />
@endpush
