@extends('admin.layouts.app')

@section('panel')
    @push('topBar')
        @include('admin.savings.top_bar')
    @endpush

    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table table--light">
                            <thead>
                                <tr>
                                    <th>@lang('Tenure')</th>
                                    <th>@lang('Interval')</th>
                                    <th>@lang('Installment Amount')</th>
                                    <th>@lang('Total Investment')</th>
                                    <th>@lang('Interest Rate')</th>
                                    <th>@lang('Maturity Amount')</th>
                                    <th>@lang('Installment Penalty Rate')</th>
                                    <th>@lang('Penalty Interval')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($dpsPlans as $item)
                                    @php
                                        $item->investment_amount = $item->investmentAmount();
                                        $item->installment_amount = getAmount($item->installment_amount);
                                        $item->maturity_amount = getAmount($item->maturity_amount);
                                    @endphp
                                    <tr>
                                        <td>{{ __(@$item->savingTenure->name) }}</td>
                                        <td>{{ __(@$item->savingInterval->name) }}</td>
                                        <td>{{ showAmount(@$item->installment_amount) }}</td>
                                        <td>{{ showAmount(@$item->investmentAmount()) }}</td>
                                        <td>{{ showAmount(@$item->interest_rate, 1, currencyFormat: false) }}%</td>
                                        <td>{{ showAmount(@$item->maturity_amount) }}</td>
                                        <td>{{ showAmount(@$item->penalty_rate, 1, currencyFormat: false) }}%</td>
                                        <td>{{ __(@$item->penaltyInterval->name) }}</td>
                                        <td>
                                            @php echo $item->statusBadge; @endphp
                                        </td>

                                        <td>
                                            <div class="button--group">
                                                <button type="button" class="btn btn-sm btn-outline--primary editBtn" data-resource="{{ $item }}" data-modal_title="@lang('Update Organization')"><i class="las la-pencil-alt"></i>@lang('Edit')</button>

                                                @if ($item->status == Status::ENABLE)
                                                    <button type="button" class="btn btn-sm btn-outline--danger confirmationBtn" data-question="@lang('Are you sure to disable this DPS plan?')" data-action="{{ route('admin.savings.org.dps.plan.status', $item->id) }}"><i class="las la-eye-slash"></i>@lang('Disable')</button>
                                                @else
                                                    <button type="button" class="btn btn-sm btn-outline--success confirmationBtn" data-question="@lang('Are you sure to enable this DPS plan?')" data-action="{{ route('admin.savings.org.dps.plan.status', $item->id) }}"><i class="las la-eye-slash"></i>@lang('Enable')</button>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="editModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Update DPS Plan')</h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form method="POST" id="edit-form">
                    @csrf
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">

                                <div class="form-group">
                                    <label>@lang('Tenure')</label>
                                    <select name="saving_tenure_id" class="form-control" required>
                                        <option value="" selected disabled>@lang('Select One')</option>
                                        @foreach ($tenures as $tenure)
                                            <option value="{{ $tenure->id }}" data-duration="{{ $tenure->duration }}">
                                                {{ __($tenure->name) }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">

                                <div class="form-group">
                                    <label>@lang('Interval')</label>
                                    <select name="saving_interval_id" class="form-control" required>
                                        <option value="" selected disabled>@lang('Select One')</option>
                                        @foreach ($intervals as $interval)
                                            <option value="{{ $interval->id }}" data-installment_interval="{{ $interval->installment_interval }}">
                                                {{ __($interval->name) }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Installment Amount')</label>
                                    <div class="input-group">
                                        <input type="number" min="0" class="form-control" name="installment_amount" required>
                                        <span class="input-group-text">{{ __(gs('cur_text')) }}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Invested Amount')</label>
                                    <div class="input-group">
                                        <input type="number" class="form-control" name="invested_amount" disabled>
                                        <span class="input-group-text">{{ __(gs('cur_text')) }}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Interest Rate')</label>
                                    <div class="input-group">
                                        <input type="number" min="0" class="form-control" name="interest_rate" required>
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Maturity Amount')</label>
                                    <div class="input-group">
                                        <input type="number" min="0" class="form-control" name="maturity_amount" required>
                                        <span class="input-group-text">{{ __(gs('cur_text')) }}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Penalty Rate')</label>
                                    <div class="input-group">
                                        <input type="number" min="0" class="form-control" name="penalty_rate" required>
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Penalty Interval')</label>
                                    <select name="penalty_interval_id" class="form-control" required>
                                        <option value="" selected disabled>@lang('Select Penalty Interval')</option>
                                        @foreach ($intervals as $interval)
                                            <option value="{{ $interval->id }}">
                                                {{ __($interval->name) }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--primary h-45 w-100">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <x-confirmation-modal />
@endsection

@push('breadcrumb-plugins')
    <x-search-form />
    <a href="{{ route('admin.savings.org.dps.plan.add', $organization->id) }}" class="btn btn-outline--primary"><i class="las la-plus"></i>@lang('Add New')</a>
@endpush

@push('script')
    <script>
        (function($) {
            'use strict';

            let modal = $('#editModal');
            $('.editBtn').on('click', function() {
                let resource = $(this).data('resource');

                let url = "{{ route('admin.savings.org.dps.plan.update', ':id') }}".replace(':id', resource
                    .id);
                modal.find('form').attr('action', url);

                modal.find('[name=saving_tenure_id]').val(resource.saving_tenure_id);
                modal.find('[name=saving_interval_id]').val(resource.saving_interval_id);
                modal.find('[name=installment_amount]').val(resource.installment_amount);
                modal.find('[name=maturity_amount]').val(resource.maturity_amount);
                modal.find('[name=interest_rate]').val(resource.interest_rate);
                modal.find('[name=penalty_interval_id]').val(resource.penalty_interval_id);
                modal.find('[name=penalty_rate]').val(resource.penalty_rate);
                modal.find('[name=invested_amount]').val(resource.investment_amount);
                modal.modal('show');
            });

            const calculateInvestmentAmount = () => {
                let tenure = modal.find('select[name="saving_tenure_id"]').find(':selected').data('duration');
                let interval = modal.find('select[name="saving_interval_id"]').find(':selected').data(
                    'installment_interval');
                let interestRate = modal.find('input[name="interest_rate"]').val();
                let installment = modal.find('input[name="installment_amount"]').val();
                let maturityAmount = modal.find('input[name="maturity_amount"]').val();

                if (!tenure || !interval || !installment || !interestRate) {
                    return false;
                }

                let investedAmount = Math.floor(tenure / interval) * (installment * 1);

                let totalMaturityAmount = investedAmount * (interestRate / 100) + investedAmount;

                if (maturityAmount != totalMaturityAmount) {
                    modal.find('input[name="maturity_amount"]').val(totalMaturityAmount);
                }

                modal.find('input[name="invested_amount"]').val(investedAmount);
            }

            $(document).on('change', '[name=saving_tenure_id], [name=saving_interval_id]', calculateInvestmentAmount);
            $(document).on('keyup', 'input[name=installment_amount]', calculateInvestmentAmount);
            $(document).on('keyup', 'input[name=interest_rate]', calculateInvestmentAmount);

        })(jQuery);
    </script>
@endpush
