@extends('admin.layouts.app')

@section('panel')
    @push('topBar')
        @include('admin.savings.top_bar')
    @endpush

    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <form action="{{ route('admin.savings.org.dps.plan.save', $organization->id) }}" method="POST">
                        @csrf
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Installment Tenure')</label>
                                    <select name="tenure_id" class="form-control" required>
                                        <option value="" selected disabled>@lang('Select Tenure')</option>
                                        @foreach ($tenures as $tenure)
                                            <option value="{{ $tenure->id }}" data-duration="{{ $tenure->duration }}"
                                                @selected(old('tenure_id') == $tenure->id)>{{ __($tenure->name) }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Installment Interval')</label>
                                    <select name="interval_id" class="form-control" required>
                                        <option value="" selected disabled>@lang('Select Interval')</option>
                                        @foreach ($intervals as $interval)
                                            <option value="{{ $interval->id }}"
                                                data-installment_interval="{{ $interval->installment_interval }}"
                                                @selected(old('interval_id') == $interval->id)>{{ __($interval->name) }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Installment Penalty Rate')</label>
                                    <div class="input-group">
                                        <input type="number" min="0" class="form-control penalty_rate"
                                            name="penalty_rate" value="{{ old('penalty_rate') }}" step="any" required>
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Penalty Interval')</label>
                                    <select name="penalty_interval_id" class="form-control" required>
                                        <option value="" selected disabled>@lang('Select Penalty Interval')</option>
                                        @foreach ($intervals as $interval)
                                            <option value="{{ $interval->id }}" @selected(old('penalty_interval_id') == $interval->id)>
                                                {{ __($interval->name) }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row installment-wrapper">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>@lang('Installment Amount')</label>
                                    <div class="input-group">
                                        <input type="number" min="0" class="form-control installment_amount"
                                            name="installment_amount[]" value="{{ old('installment_amount.0') }}" required>
                                        <span class="input-group-text">{{ __(gs('cur_text')) }}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>@lang('Interest Rate')</label>
                                    <div class="input-group">
                                        <input type="number" min="0" class="form-control interest_rate"
                                            name="interest_rate[]" value="{{ old('interest_rate.0') }}" step="any" required>
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>@lang('Invested Amount')</label>
                                    <div class="input-group">
                                        <input type="number" class="form-control" name="invested_amount" disabled>
                                        <span class="input-group-text">{{ __(gs('cur_text')) }}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>@lang('Maturity Amount')</label>
                                    <div class="input-group">
                                        <input type="number" min="0" name="maturity_amount[]"
                                            class="form-control maturity_amount" value="{{ old('maturity_amount.0') }}"
                                            required>
                                        <span class="input-group-text">{{ __(gs('cur_text')) }}</span>
                                        <button type="button" class="ms-2 btn btn--success border-radius-5 addBtn"><i
                                                class="las la-plus me-0"></i></button>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="dynamic-form-wrapper"></div>

                        <button type="submit" class="btn btn--primary w-100 h-45">@lang('Submit')</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('breadcrumb-plugins')
    <x-back route="{{ route('admin.savings.org.dps.plans', $organization->id) }}" />
@endpush

@push('script')
    <script>
        (function($) {
            'use strict';

            function calculateAmounts() {
                let tenure = $('select[name="tenure_id"]').find(':selected').data('duration');
                let interval = $('select[name="interval_id"]').find(':selected').data('installment_interval');

                if (!tenure || !interval) {
                    $('.installment-wrapper').find('[name="invested_amount"], .maturity_amount').val('');
                    return;
                }

                let timesOfInstallment = Math.round(tenure / interval);

                $('.installment-wrapper').each(function() {
                    let installment = $(this).find('.installment_amount').val();
                    let interest_rate = $(this).find('.interest_rate').val();

                    if (!installment) {
                        $(this).find('[name="invested_amount"], .maturity_amount').val('');
                        return;
                    }

                    let totalInvestedAmount = timesOfInstallment * installment;
                    let totalMaturityAmount = totalInvestedAmount * (interest_rate / 100) + totalInvestedAmount;

                    $(this).find('[name="invested_amount"]').val(totalInvestedAmount);
                    $(this).find('.maturity_amount').val(totalMaturityAmount);
                });
            }

            $(document).on('keyup change', '.installment_amount, .interest_rate', function() {
                calculateAmounts();
            });

            $(document).on('change', 'select[name="tenure_id"], select[name="interval_id"]', function() {
                calculateAmounts();
            });

            $(document).on('click', '.removeBtn', function() {
                $(this).closest('.installment-wrapper').remove();
                calculateAmounts();
            });

            $('.addBtn').on('click', function() {
                let html = `<div class="row installment-wrapper">
            <div class="col-md-3">
                <div class="form-group">
                    <label>@lang('Installment Amount')</label>
                    <div class="input-group">
                        <input type="number" min="0" class="form-control installment_amount" name="installment_amount[]" required>
                        <span class="input-group-text">{{ __(gs('cur_text')) }}</span>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    <label>@lang('Interest Rate')</label>
                    <div class="input-group">
                        <input type="number" min="0" class="form-control interest_rate" name="interest_rate[]" step="any" required>
                        <span class="input-group-text">%</span>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    <label>@lang('Invested Amount')</label>
                    <div class="input-group">
                        <input type="number" class="form-control" name="invested_amount" disabled>
                        <span class="input-group-text">{{ __(gs('cur_text')) }}</span>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    <label>@lang('Maturity Amount')</label>
                    <div class="input-group">
                        <input type="number" min="0" name="maturity_amount[]" class="form-control maturity_amount" required>
                        <span class="input-group-text">{{ __(gs('cur_text')) }}</span>
                        <button type="button" class="ms-2 btn btn--danger border-radius-5 removeBtn"><i class="las la-trash-alt me-0"></i></button>
                    </div>
                </div>
            </div>
        </div>`;

                $('.dynamic-form-wrapper').append(html);
            });

        })(jQuery);
    </script>
@endpush

@push('style')
    <style>
        .border-radius-5 {
            border-top-left-radius: 5px !important;
            border-bottom-left-radius: 5px !important;
        }
    </style>
@endpush
