@extends('admin.layouts.app')

@section('panel')
    <div class="row">
        <div class="col-md-12">
            <div class="show-filter mb-3 text-end">
                <button type="button" class="btn btn-outline--primary showFilterBtn btn-sm"><i class="las la-filter"></i>
                    @lang('Filter')</button>
            </div>
            <div class="card responsive-filter-card mb-4">
                <div class="card-body">
                    <form action="">
                        <div class="d-flex flex-wrap gap-4">
                            <div class="flex-grow-1">
                                <label>@lang('Account ID/Username')</label>
                                <input type="search" name="search" value="{{ request()->search }}" class="form-control">
                            </div>

                            <div class="flex-grow-1">
                                <label>@lang('Date')</label>
                                <x-search-date-field :icon="false" />
                            </div>
                            <div class="flex-grow-1 align-self-end">
                                <button class="btn btn--primary w-100 h-45"><i class="fas fa-filter"></i>
                                    @lang('Filter')</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table table--light">
                            <thead>
                                <tr>
                                    <th>@lang('Account ID')</th>
                                    <th>@lang('User Name')</th>
                                    <th>@lang('Organization')</th>
                                    <th>@lang('Next Installment')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($savingAccounts as $savingAccount)
                                    <tr>
                                        <td>{{ $savingAccount->account_id }}</td>
                                        <td>
                                            <span class="fw-bold">{{ $savingAccount->user->fullname }}</span>
                                            <br>
                                            <span class="small">
                                                <a
                                                    href="{{ route('admin.users.detail', $savingAccount->user->id) }}"><span>@</span>{{ $savingAccount->user->username }}</a>
                                            </span>
                                        </td>
                                        <td>{{ __(@$savingAccount->dpsPlan?->organization?->name) }}</td>
                                        <td>{{ showDateTime(@$savingAccount->next_installment_date) }}</td>
                                        <td>
                                            @php echo $savingAccount->statusBadge; @endphp
                                        </td>

                                        <td>
                                            <div class="button--group">
                                                @if ($savingAccount->nominee)

                                                <a target="_blank"
                                                    href="{{ route('admin.saving.account.nominee', $savingAccount->nominee->id) }}"
                                                    class="btn btn-sm btn-outline--primary">
                                                    <i class="las la-user"></i>
                                                    @lang('Nominee')
                                                </a>
                                                @else
                                                <a
                                                    href="javascript:void(0)"
                                                    class="btn btn-sm btn-outline--primary disabled">
                                                    <i class="las la-user"></i>
                                                    @lang('Nominee')
                                                </a>
                                                @endif

                                                <a href="{{ route('admin.saving.account.details', $savingAccount->id) }}"
                                                    class="btn btn-sm btn-outline--primary">
                                                    <i class="las la-desktop"></i>
                                                    @lang('Details')
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <x-confirmation-modal />
@endsection
