@extends('admin.layouts.app')

@section('panel')
    <div class="row">
        <div class="col-12">
            <div class="row gy-4">

                <div class="col-xxl-3 col-sm-6">
                    <x-widget style="7" link="javascript:void(0)" title="Account Balance" icon="las la-money-bill-wave-alt"
                        value="{{ showAmount(@$widget['account_balance']) }}" bg="indigo" type="2" />
                </div>

                <div class="col-xxl-3 col-sm-6">
                    <x-widget style="7" link="javascript:void(0)" title="Paid Installment" icon="las la-exchange-alt"
                        value="{{ @$widget['paid_installment'] }}" bg="17" type="2" />
                </div>

                <div class="col-xxl-3 col-sm-6">
                    <x-widget style="7" link="javascript:void(0)" title="Installment Due" icon="las la-hand-holding-usd"
                        value="{{ showAmount(@$widget['due_installment']) }}" bg="6" type="2" />
                </div>

                <div class="col-xxl-3 col-sm-6">
                    <x-widget style="7" link="javascript:void(0)" title="Maturity Amount" icon="las la-wallet"
                        value="{{ showAmount(@$widget['maturity_amount']) }}" bg="8" type="2" />
                </div>
            </div>

        </div>
        <div class="col-lg-12 mt-3">
            <div class="card b-radius--10 bg--transparent shadow-none">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table--light style--two table bg-white">
                            <thead>
                                <tr>
                                    <th>@lang('Trx')</th>
                                    <th>@lang('Amount')</th>
                                    <th>@lang('Installment Date')</th>
                                    <th>@lang('Status')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($installments as $installment)
                                    <tr>
                                        <td>
                                            <span class="d-block">{{ @$installment->trx ?? 'N/A' }}</span>
                                        </td>
                                        <td>
                                            <span class="fw-bold d-block">{{ __(showAmount(@$installment->amount)) }}</span>
                                            @if ($installment->penalty_amount > 0)
                                                <span class="text--danger">+
                                                    {{ showAmount(@$installment->penalty_amount) }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            <span
                                                class="d-block">{{ __(showDateTime(@$installment->created_at, 'd M Y')) }}
                                            </span>
                                        </td>
                                        <td>
                                            @if (@$installment->status == Status::INSTALLMENT_PAID)
                                                <div>
                                                    <span class="badge badge--success">@lang('Paid')</span>
                                                    <br>
                                                    <span>{{ __(showDateTime(@$installment->installment_paid_at)) }}</span>
                                                </div>
                                            @else
                                                <span class="badge badge--warning">@lang('Due')</span>
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
                @if ($installments->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($installments) }}
                    </div>
                @endif
            </div>
        </div>
    </div>

    <x-confirmation-modal />
@endsection
