@extends('admin.layouts.app')

@section('panel')
    @push('topBar')
        @include('admin.rewards.top_bar')
    @endpush

    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table table--light">
                            <thead>
                                <tr>
                                    <th>@lang('Name')</th>
                                    <th>@lang('Details')</th>
                                    <th>@lang('Level')</th>
                                    <th>@lang('Required Points')</th>
                                    <th>@lang('Transaction Type')</th>
                                    <th>@lang('Reward Value')</th>
                                    <th>@lang('Minimum Transaction')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($rewards as $item)
                                    <tr>
                                        <td>{{ __(@$item->name) }}</td>
                                        <td>{{ __(str()->limit(@$item->description, 20)) }}</td>
                                        <td>{{ __(@$item->level->name) }}</td>
                                        <td>{{ __($item->required_points) }} @lang('Points')</td>
                                        <td>
                                            {{ __(keyToTitle(@$item->transaction_type)) }}
                                        </td>
                                        <td>
                                            @if (@$item->reward_value_type == Status::PERCENT_VALUE)
                                                {{ showAmount(@$item->reward_value, currencyFormat: false) }}%
                                            @else
                                                {{ showAmount(@$item->reward_value) }}
                                            @endif
                                        </td>
                                        <td>{{ showAmount(@$item->min_transaction_amount) }}</td>
                                        <td>
                                            @php echo $item->statusBadge; @endphp
                                        </td>

                                        <td>
                                            <div class="button--group">
                                                <button type="button" class="btn btn-sm btn-outline--primary cuModalBtn" data-resource="{{ $item }}" data-modal_title="@lang('Update Reward')"><i class="las la-pencil-alt"></i>@lang('Edit')
                                                </button>
                                                @if ($item->status == Status::ENABLE)
                                                    <button type="button" class="btn btn-sm btn-outline--danger confirmationBtn" data-question="@lang('Are you sure to disable this reward?')" data-action="{{ route('admin.reward.status', $item->id) }}"><i class="las la-eye-slash"></i>@lang('Disable')</button>
                                                @else
                                                    <button type="button" class="btn btn-sm btn-outline--success confirmationBtn" data-question="@lang('Are you sure to enable this reward?')" data-action="{{ route('admin.reward.status', $item->id) }}"><i class="las la-eye-slash"></i>@lang('Enable')</button>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="cuModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form method="POST" action="{{ route('admin.reward.store') }}">
                    @csrf
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>@lang('Name')</label>
                                    <input type="text" class="form-control" name="name" required>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>@lang('Description')</label>
                                    <textarea name="description" class="form-control" rows="4" required></textarea>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Level Required')</label>
                                    <select name="level_id" class="form-control select2" data-minimum-results-for-search="-1" required>
                                        <option value="">@lang('Select One')</option>
                                        @foreach ($levels as $level)
                                            <option value="{{ $level->id }}" data-level='@json($level)'>
                                                {{ $level->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Required Points')</label>
                                    <div class="input-group">
                                        <input type="number" min="1" class="form-control" name="required_points" required>
                                        <span class="input-group-text">@lang('Points')</span>
                                    </div>
                                    <span class="form-text text--muted"></span>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Reward Value')</label>
                                    <div class="input-group">
                                        <input type="number" class="form-control" min="0" step="any" name="reward_value" required>
                                        <select name="reward_value_type" class="input-group-text">
                                            <option value="{{ Status::FIXED_VALUE }}">@lang('Fixed')</option>
                                            <option value="{{ Status::PERCENT_VALUE }}">@lang('Percent')</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Transaction Type')</label>
                                    <select name="transaction_type" class="form-control select2" required>
                                        <option value="">@lang('Select One')</option>
                                        @foreach (allRemarks() ?? [] as $item)
                                            <option value="{{ $item }}">{{ __(keyToTitle(@$item)) }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Min Transaction Amount')</label>
                                    <div class="input-group">
                                        <input type="number" class="form-control" name="min_transaction_amount" required>
                                        <span class="input-group-text">{{ __(gs('cur_text')) }}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>@lang('Validity Days')</label>
                                    <div class="input-group">
                                        <input type="number" class="form-control" name="validity_days" required>
                                        <span class="input-group-text">@lang('Days')</span>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div class="modal--footer">
                            <button type="submit" class="btn btn--primary w-100 h-45">@lang('Submit')</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <x-confirmation-modal />
@endsection

@push('breadcrumb-plugins')
    <button type="button" class="btn btn-sm btn-outline--primary cuModalBtn" data-modal_title="@lang('Add Reward')"><i class="las la-plus"></i>@lang('Add New')</button>
@endpush

@push('script')
    <script>
        (function($) {
            'use strict';

            $('select[name="level_id"]').on('change', function() {
                let level = $(this).find(':selected').data('level');
                let requiredPoints = $('input[name="required_points"]');
                let formText = requiredPoints.closest('.form-group').find('.form-text');

                if (level) {
                    requiredPoints.attr('min', level.min_points).attr('max', level.max_points);
                    formText.text(
                        `@lang('min'): ${level.min_points} - @lang('max'): ${level.max_points}`
                    );
                } else {
                    formText.text('');
                }
            })

        })(jQuery);
    </script>
@endpush
