@extends('admin.layouts.app')

@section('panel')
    @push('topBar')
        @include('admin.rewards.top_bar')
    @endpush
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table table--light">
                            <thead>
                                <tr>
                                    <th>@lang('Name')</th>
                                    <th>@lang('Points Limit')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($levels as $item)
                                    <tr>
                                        <td>{{ __($item->name) }}</td>

                                        <td>{{ $item->min_points }} - {{ $item->max_points }}</td>

                                        <td>
                                            @php echo $item->statusBadge; @endphp
                                        </td>

                                        <td>
                                            <div class="button--group">
                                                <button type="button" class="btn btn-sm btn-outline--primary cuModalBtn"
                                                    data-resource="{{ $item }}"
                                                    data-modal_title="@lang('Update Level')"><i
                                                        class="las la-pencil-alt"></i>@lang('Edit')</button>

                                                @if ($item->status == Status::ENABLE)
                                                    <button type="button"
                                                        class="btn btn-sm btn-outline--danger confirmationBtn"
                                                        data-question="@lang('Are you sure to disable this level?')"
                                                        data-action="{{ route('admin.reward.level.status', $item->id) }}"><i
                                                            class="las la-eye-slash"></i>@lang('Disable')</button>
                                                @else
                                                    <button type="button"
                                                        class="btn btn-sm btn-outline--success confirmationBtn"
                                                        data-question="@lang('Are you sure to enable this level?')"
                                                        data-action="{{ route('admin.reward.level.status', $item->id) }}"><i
                                                            class="las la-eye-slash"></i>@lang('Enable')</button>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="cuModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form method="POST" action="{{ route('admin.reward.level.store') }}">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <label>@lang('Name')</label>
                            <input type="text" class="form-control" name="name" required>
                        </div>
                        <div class="form-group">
                            <label>@lang('Min Points')</label>
                            <div class="input-group">
                                <input type="number" class="form-control" min="0" name="min_points"
                                    value="{{ old('min_points') }}" required>
                                <span class="input-group-text">@lang('Points')</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label>@lang('Max Points')</label>
                            <div class="input-group">
                                <input type="number" min="1" class="form-control" name="max_points"
                                    value="{{ old('max_points') }}" required>
                                <span class="input-group-text">@lang('Points')</span>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--primary w-100 h-45">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <x-confirmation-modal />
@endsection

@push('breadcrumb-plugins')
    <button type="button" class="btn btn-sm btn-outline--primary cuModalBtn" data-modal_title="@lang('Add Level')"><i
            class="las la-plus"></i>@lang('Add New')</button>
@endpush
