<!-- meta tags and other links -->
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ gs()->siteName($pageTitle ?? '') }}</title>

    <link rel="shortcut icon" type="image/png" href="{{ siteFavicon() }}">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('assets/global/css/bootstrap.min.css') }}">

    <link rel="stylesheet" href="{{ asset('assets/admin/css/vendor/bootstrap-toggle.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/global/css/all.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/global/css/line-awesome.min.css') }}">

    @stack('style-lib')

    <link rel="stylesheet" href="{{ asset('assets/global/css/select2.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/admin/css/app.css') }}">

    @stack('style')
</head>

<body>
    @yield('content')

    <script src="{{ asset('assets/global/js/jquery-3.7.1.min.js') }}"></script>
    <script src="{{ asset('assets/global/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('assets/admin/js/vendor/bootstrap-toggle.min.js') }}"></script>

    @include('partials.notify')
    @stack('script-lib')

    <script src="{{ asset('assets/global/js/nicEdit.js') }}"></script>

    <script src="{{ asset('assets/global/js/select2.min.js') }}"></script>
    <script src="{{ asset('assets/admin/js/app.js') }}"></script>
    <script src="{{ asset('assets/global/js/cu-modal.js') }}"></script>
    <script src="{{ asset('assets/global/js/firebase/firebase-8.3.2.js') }}"></script>

    {{-- LOAD NIC EDIT --}}
    <script>
        "use strict";
        bkLib.onDomLoaded(function() {
            $(".nicEdit").each(function(index) {
                $(this).attr("id", "nicEditor" + index);
                new nicEditor({
                    fullPanel: true
                }).panelInstance('nicEditor' + index, {
                    hasPanel: true
                });
            });
        });
        (function($) {
            $(document).on('mouseover ', '.nicEdit-main,.nicEdit-panelContain', function() {
                $('.nicEdit-main').focus();
            });

            $('.breadcrumb-nav-open').on('click', function() {
                $(this).toggleClass('active');
                $('.breadcrumb-nav').toggleClass('active');
            });

            $('.breadcrumb-nav-close').on('click', function() {
                $('.breadcrumb-nav').removeClass('active');
            });

            if ($('.topTap').length) {
                $('.breadcrumb-nav-open').removeClass('d-none');
            }


            $(document).on('mouseover ', '.nicEdit-main,.nicEdit-panelContain', function() {
                $('.nicEdit-main').focus();
            });

            var permission = null;
            var pushNotify = @json(gs('pn'));
            var firebaseConfig = @json(gs('firebase_config'));

            function pushNotifyAction() {
                permission = Notification.permission;
            }

            //If enable push notification from admin panel
            if (pushNotify == {{ Status::ENABLE }}) {
                pushNotifyAction();
            }

            //When users allow browser notification
            if (permission != 'denied' && firebaseConfig) {

                //Firebase
                firebase.initializeApp(firebaseConfig);
                const messaging = firebase.messaging();

                navigator.serviceWorker.register("{{ asset('assets/global/js/firebase/firebase-messaging-sw.js') }}")

                    .then((registration) => {
                        messaging.useServiceWorker(registration);

                        function initFirebaseMessagingRegistration() {
                            messaging
                                .requestPermission()
                                .then(function() {
                                    return messaging.getToken()
                                })
                                .then(function(token) {
                                    $.ajax({
                                        url: '{{ route('admin.push.device.token') }}',
                                        type: 'POST',
                                        data: {
                                            token: token,
                                            '_token': "{{ csrf_token() }}"
                                        },
                                        success: function(response) {
                                            // console.log(response);
                                        },
                                        error: function(err) {
                                            // console.log('User Chat Token Error'+ err);
                                        },
                                    });
                                }).catch(function(error) {
                                    // console.warn(error);
                                });
                        }

                        messaging.onMessage(function(payload) {
                            const title = payload.notification.title;
                            const options = {
                                body: payload.notification.body,
                                icon: payload.notification.icon,
                                click_action: payload.notification.click_action,
                                vibrate: [200, 100, 200]
                            };
                            new Notification(title, options);
                        });

                        initFirebaseMessagingRegistration();
                    });

            }

        })(jQuery);
    </script>

    @stack('script')

</body>

</html>
