@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('Invoice Id')</th>
                                    <th>@lang('User')</th>
                                    <th>@lang('Merchant')</th>
                                    <th>@lang('Total Amount')</th>
                                    <th>@lang('Created At')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($invoices as $invoice)
                                    <tr>
                                        <td>
                                            #{{ $invoice->uid }}
                                        </td>
                                        <td>
                                            <span class="fw-bold">{{ $invoice->user->fullname }}</span>
                                            <br>
                                            <span class="small">
                                                <a href="{{ route('admin.users.detail', $invoice->user->id) }}"><span>@</span>{{ $invoice->user->username }}</a>
                                            </span>
                                        </td>

                                        <td>
                                            <span class="fw-bold">{{ $invoice->merchant->fullname }}</span>
                                            <br>
                                            <span class="small">
                                                <a href="{{ route('admin.merchants.detail', $invoice->merchant->id) }}"><span>@</span>{{ $invoice->merchant->username }}</a>
                                            </span>
                                        </td>


                                        <td>
                                            {{ showAmount($invoice->total_amount) }}
                                        </td>
                                        <td>
                                            {{ $invoice->created_at }}
                                        </td>

                                        <td>
                                            @php echo $invoice->statusBadge @endphp
                                        </td>

                                        <td>
                                            <a href="{{ route('admin.invoice.download',$invoice->id) }}" class="btn btn-sm btn-outline--primary detailBtn">
                                                <i class="las la-cloud-download-alt"></i> @lang('Download')
                                            </a>
                                        </td>

                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse

                            </tbody>
                        </table>
                    </div>
                </div>
                @if ($invoices->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($invoices) }}
                    </div>
                @endif
            </div>
        </div>
    </div>


    <div id="rejectModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p class="reason_text"></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn--dark btn-sm" data-bs-dismiss="modal">@lang('Close')</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('breadcrumb-plugins')
    <form class="d-flex flex-wrap gap-2" id="searchForm">
        <select name="status" class="select2" data-minimum-results-for-search="-1">
            <option value="" @selected(request()->status === null || request()->status === '')>@lang('Status')</option>
            <option value="1" @selected(request()->status == 1)>@lang('Paid')</option>
            <option value="0" @selected(request()->status == '0')>@lang('Unpaid')</option>
            <option value="3" @selected(request()->status == 3)>@lang('Canceled')</option>
            <option value="2" @selected(request()->status == 2)>@lang('Rejected')</option>
        </select>
        <div class="input-group w-auto flex-fill">
            <input type="search" name="search" class="form-control bg--white" placeholder="Username/Email" value="{{ request()->search }}">
            <button class="btn btn--primary" type="submit"><i class="la la-search"></i></button>
        </div>
    </form>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";
            $('select[name=status]').on('change', function() {
                $('#searchForm').submit();
            })

            $('.rejectBtn').on('click', function() {
                var modal = $('#rejectModal');
                var title = $(this).data('title');
                var reason = $(this).data('reason');
                modal.find('.modal-title').text(title)
                modal.find('.reason_text').text(reason)
                modal.modal('show');
            })

        })(jQuery)
    </script>
@endpush

@push('style')
    <style>
        .select2-container .select2-selection--single {
            width: 160px !important;
        }
    </style>
@endpush
