@extends('admin.layouts.app')

@section('panel')
    <div class="row justify-content-center">
        <div class="col-xxl-3 col-sm-6 mb-30">
            <div class="widget-two box--shadow2 b-radius--5 bg--1">
                <div class="widget-two__content">
                    <h2 class="text-white">{{ showAmount($data['today']) }}</h2>
                    <p class="text-white">@lang('Today\'s Donation')</p>
                </div>
            </div><!-- widget-two end -->
        </div>
        <div class="col-xxl-3 col-sm-6 mb-30">
            <div class="widget-two box--shadow2 b-radius--5 bg--10 has-link">
                <div class="widget-two__content">
                    <h2 class="text-white">{{ showAmount($data['this_month']) }}</h2>
                    <p class="text-white">@lang('This Month Donation')</p>
                </div>
            </div><!-- widget-two end -->
        </div>
        <div class="col-xxl-3 col-sm-6 mb-30">
            <div class="widget-two box--shadow2 has-link b-radius--5 bg--success">
                <div class="widget-two__content">
                    <h2 class="text-white">{{ showAmount($data['this_year']) }}</h2>
                    <p class="text-white">@lang('This Year Donation')</p>
                </div>
            </div><!-- widget-two end -->
        </div>
        <div class="col-xxl-3 col-sm-6 mb-30">
            <div class="widget-two box--shadow2 has-link b-radius--5 bg--15">
                <div class="widget-two__content">
                    <h2 class="text-white">{{ showAmount($data['all']) }}</h2>
                    @if (request()->date)
                        <p class="text-white">{{ request()->date }}</p>
                    @else
                        <p class="text-white">@lang('All Time Donation')</p>
                    @endif
                </div>
            </div><!-- widget-two end -->
        </div>

        <div class="col-lg-12">
            <div class="show-filter mb-3 text-end">
                <button type="button" class="btn btn-outline--primary showFilterBtn btn-sm"><i class="las la-filter"></i> @lang('Filter')</button>
            </div>
            <div class="card responsive-filter-card mb-4">
                <div class="card-body">
                    <form action="">
                        <div class="d-flex flex-wrap gap-4">
                            <div class="flex-grow-1">
                                <label>@lang('TRX/Username/Reference')</label>
                                <input type="search" name="search" value="{{ request()->search }}" class="form-control">
                            </div>
                            <div class="flex-grow-1">
                                <label>@lang('Donation For')</label>
                                <select name="setup_donation_id" class="form-control select2" data-minimum-results-for-search="-1">
                                    <option value="">@lang('All')</option>
                                    @foreach ($setupDonations as $stDonation)
                                        <option value="{{ $stDonation->id }}" @selected(request()->setup_donation_id == $stDonation->id)>{{ $stDonation->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="flex-grow-1">
                                <label>@lang('Date')</label>
                                <x-search-date-field :icon="false" />
                            </div>
                            <div class="flex-grow-1 align-self-end">
                                <button class="btn btn--primary w-100 h-45"><i class="fas fa-filter"></i> @lang('Filter')</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <div class="card b-radius--10 bg--transparent shadow-none">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table--light style--two table bg-white">
                            <thead>
                                <tr>
                                    <th>@lang('Transacted')</th>
                                    <th>@lang('Donation For')</th>
                                    <th>@lang('Amount')</th>
                                    <th>@lang('Identity')</th>
                                    <th>@lang('Trx | Reference')</th>
                                    <th>@lang('User')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($donations as $data)
                                    <tr>
                                        <td>
                                            <div>
                                                <span class="fw-bold d-block">{{ showDateTime($data->created_at) }}</span>
                                                <span>{{ diffForHumans($data->created_at) }}</span>
                                            </div>
                                        </td>
                                        <td>
                                            <div>
                                                <span class="fw-bold d-block">{{ __(@$data->donationFor->name) }}</span>
                                                <small>{{ strLimit(@$data->donationFor->address, 50) }}</small>
                                            </div>
                                        </td>
                                        <td>
                                            <span class="fw-bold d-block">{{ showAmount($data->amount) }}</span>
                                        </td>
                                        <td>
                                            <div>
                                                @if ($data->hide_identity == Status::YES)
                                                    <span class="badge badge--dark">@lang('Hide Identity')</span>
                                                @else
                                                    <span class="badge badge--primary">@lang('Visible Identity')</span>
                                                @endif
                                            </div>
                                        </td>
                                        <td>
                                            <div>
                                                <span class="fw-bold d-block">
                                                    <a href="{{ route('admin.report.transaction', ['search' => $data->trx]) }}">{{ @$data->trx }}</a>
                                                </span>
                                                <small> {{ $data->reference }} </small>
                                            </div>
                                        </td>
                                        <td>
                                            <span class="fw-bold">{{ @$data->user->fullname }}</span>
                                            <br>
                                            <span class="small">
                                                <a href="{{ route('admin.users.detail', $data->user_id) }}"><span>@</span>{{ $data->user->username }}</a>
                                            </span>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                @if ($donations->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($donations) }}
                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection
