@extends('admin.layouts.app')

@section('panel')
    <div class="row justify-content-center">
        @if (request()->routeIs('admin.bank.transfer.all'))
            <div class="col-xxl-3 col-sm-6 mb-30">
                <div class="widget-two box--shadow2 b-radius--5 bg--warning">
                    <div class="widget-two__content">
                        <h2 class="text-white">{{ showAmount($pending) }}</h2>
                        <p class="text-white">@lang('Total Pending Amount')</p>
                    </div>
                </div><!-- widget-two end -->
            </div>
            <div class="col-xxl-3 col-sm-6 mb-30">
                <div class="widget-two box--shadow2 b-radius--5 bg--success has-link">
                    <div class="widget-two__content">
                        <h2 class="text-white">{{ showAmount($approved) }}</h2>
                        <p class="text-white">@lang('Total Approved Amount')</p>
                    </div>
                </div><!-- widget-two end -->
            </div>
            <div class="col-xxl-3 col-sm-6 mb-30">
                <div class="widget-two box--shadow2 has-link b-radius--5 bg--pink">
                    <div class="widget-two__content">
                        <h2 class="text-white">{{ showAmount($rejected) }}</h2>
                        <p class="text-white">@lang('Total Rejected Amount')</p>
                    </div>
                </div><!-- widget-two end -->
            </div>
            <div class="col-xxl-3 col-sm-6 mb-30">
                <div class="widget-two box--shadow2 has-link b-radius--5 bg--dark">
                    <div class="widget-two__content">
                        <h2 class="text-white">{{ showAmount($all) }}</h2>
                        <p class="text-white">@lang('Total Amount')</p>
                    </div>
                </div><!-- widget-two end -->
            </div>
        @endif

        <div class="col-md-12">
            <div class="show-filter mb-3 text-end">
                <button type="button" class="btn btn-outline--primary showFilterBtn btn-sm"><i class="las la-filter"></i> @lang('Filter')</button>
            </div>
            <div class="card responsive-filter-card mb-4">
                <div class="card-body">
                    <form action="">
                        <div class="d-flex flex-wrap gap-4">
                            <div class="flex-grow-1">
                                <label>@lang('TRX/Username/Bill Name')</label>
                                <input type="search" name="search" value="{{ request()->search }}" class="form-control">
                            </div>

                            <div class="flex-grow-1">
                                <label>@lang('Date')</label>
                                <x-search-date-field :icon="false" />
                            </div>
                            <div class="flex-grow-1 align-self-end">
                                <button class="btn btn--primary w-100 h-45"><i class="fas fa-filter"></i> @lang('Filter')</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-lg-12">
            <div class="card b-radius--10 bg--transparent shadow-none">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table--light style--two table bg-white">
                            <thead>
                                <tr>
                                    <th>@lang('Transacted')</th>
                                    <th>@lang('Bank')</th>
                                    <th>@lang('Account Holder')</th>
                                    <th>@lang('Amount')</th>
                                    <th>@lang('User')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($transfers as $transfer)
                                    <tr>
                                        <td>
                                            <div>
                                                <span class="fw-bold d-block">{{ showDateTime($transfer->created_at) }}</span>
                                                <span>{{ diffForHumans($transfer->created_at) }}</span>
                                            </div>
                                        </td>
                                        <td>
                                            <span class="fw-bold d-block">{{ __(@$transfer->bank->name) }}</span>
                                        </td>
                                        <td>
                                            <div>
                                                <span class="fw-bold d-block" title="@lang('Account Holder')">{{ __($transfer->account_holder) }}</span>
                                                <span title="@lang('Account Number')">{{ $transfer->account_number }}</span>
                                            </div>
                                        </td>
                                        <td>
                                            <div>
                                                <span class="fw-bold d-block">{{ showAmount($transfer->amount) }}</span>
                                                <a href="{{ route('admin.report.transaction', ['search' => $transfer->getTrx->trx]) }}">{{ $transfer->getTrx->trx }}</a>
                                            </div>
                                        </td>
                                        <td>
                                            <span class="fw-bold">{{ $transfer->user->fullname }}</span>
                                            <br>
                                            <span class="small">
                                                <a href="{{ route('admin.users.detail', $transfer->user_id) }}"><span>@</span>{{ $transfer->user->username }}</a>
                                            </span>
                                        </td>
                                        <td>
                                            @php echo $transfer->statusBadge; @endphp
                                        </td>
                                        <td>
                                            <div class="button--group">
                                                <button class="btn btn-sm btn-outline--primary actionBtn" data-data="{{ $transfer }}" data-amount="{{ showAmount($transfer->amount) }}">
                                                    <i class="la la-cog"></i> @lang('Action')
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
                @if ($transfers->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($transfers) }}
                    </div>
                @endif
            </div>
        </div>
    </div>

    <div id="actionModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="createModalLabel">@lang('Bank Transfer')</h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form class="form-horizontal" method="post" action="{{ route('admin.bank.transfer.change.status') }}">
                    @csrf
                    <input type="hidden" name="id" required>
                    <div class="modal-body">
                        <ul class="list-group list-group-flush mb-3">
                        </ul>
                        <div class="row">
                            <div class="col-lg-12 status-area">
                                <div class="form-group">
                                    <label>@lang('Select Status')</label>
                                    <select name="status" class="form-control select2" data-minimum-results-for-search="-1" required>
                                        <option value="">@lang('Select One')</option>
                                        <option value="{{ Status::APPROVED }}">@lang('Approve')</option>
                                        <option value="{{ Status::REJECTED }}">@lang('Reject')</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-12 reason d-none">
                                <div class="form-group">
                                    <label>@lang('Reason for Rejection')</label>
                                    <textarea name="message" class="form-control" rows="3">{{ old('message') }}</textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--primary h-45 w-100">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection


@push('script')
    <script>
        (function($) {
            "use strict";
            $('.actionBtn').on('click', function() {
                var modal = $('#actionModal');
                var data = $(this).data('data');
                var amount = $(this).data('amount');
                var userData = data.user_data;

                if (data.status != 0) { // 0 => Pending
                    modal.find('.modal-footer').addClass('d-none');
                    $('.status-area').addClass('d-none');
                } else {
                    modal.find('.modal-footer').removeClass('d-none');
                    $('.status-area').removeClass('d-none');
                }

                if (data.status == 2) { // 2 => Rejected
                    $('[name=message]').prop('readonly', true).val(data.admin_feedback).parents('.reason').removeClass('d-none');
                } else {
                    $('[name=message]').prop('readonly', false).val('').parents('.reason').addClass('d-none');
                }

                var html = `
                    <li class="list-group-item px-0 justify-content-between d-flex flex-wrap">
                        <span>@lang('Status')</span>
                        <span class='fw-bold'>${data.status_badge}</span>
                    </li>
                    <li class="list-group-item px-0 justify-content-between d-flex flex-wrap">
                        <span>@lang('Bank')</span>
                        <span class='fw-bold'>${data.bank.name}</span>
                    </li>
                    <li class="list-group-item px-0 justify-content-between d-flex flex-wrap">
                        <span>@lang('Account Holder')</span>
                        <span class='fw-bold'>${data.account_holder}</span>
                    </li>
                    <li class="list-group-item px-0 justify-content-between d-flex flex-wrap">
                        <span>@lang('Account Number')</span>
                        <span class='fw-bold'>${data.account_number}</span>
                    </li>
                    <li class="list-group-item px-0 justify-content-between d-flex flex-wrap">
                        <span>@lang('Amount')</span>
                        <span class='fw-bold'>${amount}</span>
                    </li>
                    <li class="list-group-item px-0 justify-content-between d-flex flex-wrap">
                        <span>@lang('User')</span>
                        <span class='fw-bold'>${data.user.firstname+' '+data.user.lastname}</span>
                    </li>
                `;

                userData.forEach(element => {
                    if (element.type != 'file') {
                        html += `
                        <li class="list-group-item px-0 justify-content-between d-flex flex-wrap">
                            <span>${element.name}</span>
                            <span class='fw-bold'>${element.value ?? 'N/A'}</span>
                        </li>`;
                    }

                    if (element.type == 'file') {
                        html += `
                        <li class="list-group-item px-0 justify-content-between d-flex flex-wrap">
                            <span>${element.name}</span>
                            <a href="{{ route('home') . '/' . getFilePath('verify') }}/${element.value}" download class='fw-bold'>@lang('Attachment')</a>
                        </li>`;
                    }
                });

                modal.find('.list-group').html(html);
                modal.find('input[name=id]').val(data.id);
                modal.modal('show');
            });

            $('select[name=status]').on('change', function() {
                if ($(this).val() == 2) {
                    $('[name=message]').prop('required', true);
                    return $('.reason').removeClass('d-none');
                }
                $('[name=message]').prop('required', false);
                return $('.reason').addClass('d-none');
            }).change();

        })(jQuery);
    </script>
@endpush
