@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('User')</th>
                                    <th>@lang('Amount')</th>
                                    <th>@lang('Payment Type')</th>
                                    <th>@lang('Payment Days')</th>
                                    <th>@lang('Next Payment')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($autoPayments as $autoPayment)
                                    <tr>
                                        <td>
                                            <span class="fw-bold">{{ $autoPayment->user->fullname }}</span>
                                            <br>
                                            <span class="small">
                                                <a href="{{ route('admin.users.detail', $autoPayment->user->id) }}"><span>@</span>{{ $autoPayment->user->username }}</a>
                                            </span>
                                        </td>


                                        <td>
                                            {{ showAmount($autoPayment->amount) }}
                                        </td>
                                        <td>
                                            {{ strtoupper($autoPayment->payment_type) }}
                                        </td>
                                        <td>
                                            {{ $autoPayment->payment_days }}
                                        </td>

                                        <td>
                                            {{ showDateTime($autoPayment->next_payment, 'd-m-Y') }}
                                            <br>
                                            <span>{{ diffForHumans($autoPayment->next_payment) }}</span>
                                        </td>
                                        <td>
                                            @php echo $autoPayment->statusBadge @endphp
                                        </td>

                                        <td>
                                            <button class="btn btn-sm btn-outline--primary detailBtn" data-info='@json($autoPayment)'>
                                                <i class="las la-desktop"></i> @lang('Details')
                                            </button>
                                        </td>

                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse

                            </tbody>
                        </table>
                    </div>
                </div>
                @if ($autoPayments->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($autoPayments) }}
                    </div>
                @endif
            </div>
        </div>
    </div>


    <div id="detailModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Details')</h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>

                <div class="modal-body">
                    <div class="details-data">
                        <h6 class="mb-2">@lang('Mobile Recharge Information :')</h6>
                        <p class="operator">@lang('Operator :') <b></b></p>
                        <ul></ul>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn--dark" data-bs-dismiss="modal">@lang('Ok')</button>
                </div>

            </div>
        </div>
    </div>
@endsection

@push('breadcrumb-plugins')
    <form class="d-flex flex-wrap gap-2" id="searchForm">
        <select name="payment_type" class="select2" data-minimum-results-for-search="-1">
            <option value="">@lang('Payment Type')</option>
            <option value="send_money" @selected(request()->payment_type == 'send_money')>@lang('Send Money')</option>
            <option value="mobile_recharge" @selected(request()->payment_type == 'mobile_recharge')>@lang('Mobile Recharge')</option>
            <option value="utility_bill" @selected(request()->payment_type == 'utility_bill')>@lang('Utility Bill')</option>
        </select>
        <select name="payment_days" class="select2" data-minimum-results-for-search="-1">
            <option value="">@lang('Payment Days')</option>
            <option value="monthly" @selected(request()->payment_days == 'monthly')>@lang('Montyly')</option>
            <option value="15days" @selected(request()->payment_days == '15days')>@lang('15 Days')</option>
            <option value="weekly" @selected(request()->payment_days == 'weekly')>@lang('Weekly')</option>
        </select>
        <div class="input-group w-auto flex-fill">
            <input type="search" name="search" class="form-control bg--white" placeholder="Username/Email" value="{{ request()->search }}">
            <button class="btn btn--primary" type="submit"><i class="la la-search"></i></button>
        </div>
    </form>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";
            $('select[name=payment_type],select[name=payment_days]').on('change', function() {
                $('#searchForm').submit();
            })

            $('.detailBtn').on('click', function() {
                var modal = $('#detailModal');

                let data = $(this).data('info');
                let paymentType = data.payment_type;

                modal.find('.details-data .operator').hide();
                let html = '';

                if (paymentType == 'mobile_recharge') {
                    $.each(data.user_data, function(index, value) {
                        html += `<li>${index} : <b>${value}</b></li>`;
                    });

                    modal.find('.details-data ul').html(html);
                    modal.find('.details-data .operator').show();
                    modal.find('.details-data .operator b').text(data.mobile_operator.name);
                    modal.find('.details-data h6').text('Mobile Recharge Information :');
                }

                if (paymentType == 'utility_bill') {
                    $.each(data.user_data, function(index, item) {
                        html += `<li>${item.name}: <b>${item.value}</b></li>`
                    });
                    modal.find('.details-data ul').html(html);
                    modal.find('.details-data h6').text('Pay Bill Information :');
                }

                if (paymentType == 'send_money') {
                    console.log(data.receiver.username);
                    html += `<li>Username : <b>${data.receiver.username}</b> </li><li> Email : <b>${data.receiver.email}</b></li>`;
                    modal.find('.details-data ul').html(html);
                    modal.find('.details-data h6').text('Reciver Information :');
                }

                modal.modal('show');
            })
        })(jQuery)
    </script>
@endpush

@push('style')
    <style>
        .select2-container .select2-selection--single {
            width: 160px !important;
        }
    </style>
@endpush
