@extends('admin.layouts.app')

@push('topBar')
    @include('admin.airtime.top_bar')
@endpush

@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10">
                <div class="card-body p-0">
                    <div class="table-responsive--lg table-responsive">
                        <table class="table--light style--two table">
                            <thead>
                                <tr>
                                    <th>@lang('Name') | @lang('Calling Codes')</th>
                                    <th>@lang('ISO') | @lang('Continent')</th>
                                    <th>@lang('Currency Name') | @lang('Currency Code')</th>
                                    <th>@lang('Currency Symbol')</th>
                                    <th>@lang('Total Operator')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>

                            <tbody>
                                @forelse($countries as $country)
                                    <tr>
                                        <td>
                                            <div>
                                                {{ __($country->name) }} <br />
                                                {{ implode(', ', $country->calling_codes) }}
                                            </div>
                                        </td>
                                        <td>
                                            <div>{{ $country->iso_name }} <br> {{ __($country->continent) }}</div>
                                        </td>
                                        <td>
                                            <div>
                                                {{ __($country->currency_name) }} <br>
                                                {{ $country->currency_code }}
                                            </div>
                                        </td>
                                        <td>{{ $country->currency_symbol }}</td>
                                        <td>
                                            {{ $country->operators_count }}
                                        </td>
                                        <td>
                                            @php echo $country->statusBadge @endphp
                                        </td>
                                        <td>
                                            <div class="button--group">
                                                <a href="{{ route('admin.airtime.operators', $country->iso_name) }}" class="btn btn-outline--dark btn-sm"><i class="las la-list"></i>@lang('Operators')</a>
                                                @if ($country->status == Status::ENABLE)
                                                    <button type="button" class="btn btn-sm btn-outline--danger confirmationBtn" data-action="{{ route('admin.airtime.country.status', $country->id) }}" data-question="@lang('Are you sure to disable this country?')">
                                                        <i class="las la-eye-slash"></i>@lang('Disable')
                                                    </button>
                                                @else
                                                    <button type="button" class="btn btn-sm btn-outline--success confirmationBtn" data-action="{{ route('admin.airtime.country.status', $country->id) }}" data-question="@lang('Are you sure to enable this country?')">
                                                        <i class="las la-eye"></i> @lang('Enable')
                                                    </button>
                                                @endif
                                            </div>
                                        </td>

                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
                @if ($countries->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($countries) }}
                    </div>
                @endif
            </div>
        </div>
    </div>

    <x-confirmation-modal />
@endsection

@push('breadcrumb-plugins')
    <a href="{{ route('admin.airtime.fetch.countries') }}" class="btn btn--dark"> <i class="lab la-telegram-plane"></i>
        @if ($countries->count())
            @lang('Fetch More Countries')
        @else
            @lang('Fetch Countries')
        @endif
    </a>
    <x-search-form placeholder="Name / ISO / Code" />
@endpush
