<?php
namespace App\Traits;

use App\Constants\Status;

trait UserNotify
{
    public static function notifyToUser()
    {
        return [
            'allUsers'                     => 'All Users',
            'selectedUsers'                => 'Selected Users',
            'hasMobileRechargedUsers'      => 'Mobile Recharged Users',
            'notMobileRechargedUsers'      => 'Not Mobile Recharged Users',
            'pendingMobileRechargedUsers'  => 'Pending Mobile Recharged Users',
            'rejectedMobileRechargedUsers' => 'Rejected Mobile Recharged Users',
            'hasDonationUsers'             => 'Donated Users',
            'notDonationUsers'             => 'Not Donated Users',
            'hasUtilityBillUsers'          => 'Utility Bill Users',
            'notUtilityBillUsers'          => 'Not Utility Bill Users',
            'pendingUtilityBillUsers'      => 'Pending Utility Bill Users',
            'rejectedUtilityBillUsers'     => 'Rejected Utility Bill Users',
            'hasBankTransferredUsers'      => 'Bank Transferred Users',
            'notBankTransferredUsers'      => 'Not Bank Transferred Users',
            'pendingBankTransferredUsers'  => 'Pending Bank Transferred Users',
            'rejectedBankTransferredUsers' => 'Rejected Bank Transferred Users',
            'kycUnverified'                => 'Kyc Unverified Users',
            'kycVerified'                  => 'Kyc Verified Users',
            'kycPending'                   => 'Kyc Pending Users',
            'withBalance'                  => 'With Balance Users',
            'emptyBalanceUsers'            => 'Empty Balance Users',
            'twoFaDisableUsers'            => '2FA Disable User',
            'twoFaEnableUsers'             => '2FA Enable User',
            'hasDepositedUsers'            => 'Deposited Users',
            'notDepositedUsers'            => 'Not Deposited Users',
            'pendingDepositedUsers'        => 'Pending Deposited Users',
            'rejectedDepositedUsers'       => 'Rejected Deposited Users',
            'topDepositedUsers'            => 'Top Deposited Users',
            'hasWithdrawUsers'             => 'Withdraw Users',
            'pendingWithdrawUsers'         => 'Pending Withdraw Users',
            'rejectedWithdrawUsers'        => 'Rejected Withdraw Users',
            'pendingTicketUser'            => 'Pending Ticket Users',
            'answerTicketUser'             => 'Answer Ticket Users',
            'closedTicketUser'             => 'Closed Ticket Users',
            'notLoginUsers'                => 'Last Few Days Not Login Users',
        ];
    }

    public function scopeSelectedUsers($query)
    {
        return $query->whereIn('id', request()->user ?? []);
    }

    public function scopeAllUsers($query)
    {
        return $query;
    }

    public function scopeEmptyBalanceUsers($query)
    {
        return $query->where('balance', '<=', 0);
    }

    public function scopeTwoFaDisableUsers($query)
    {
        return $query->where('ts', Status::DISABLE);
    }

    public function scopeTwoFaEnableUsers($query)
    {
        return $query->where('ts', Status::ENABLE);
    }

    public function scopeHasMobileRechargedUsers($query)
    {
        return $query->whereHas('mobileRecharges', function ($mobileRecharge) {
            $mobileRecharge->approved();
        });
    }

    public function scopeNotMobileRechargedUsers($query)
    {
        return $query->whereDoesntHave('mobileRecharges', function ($mobileRecharge) {
            $mobileRecharge->approved();
        });
    }

    public function scopePendingMobileRechargedUsers($query)
    {
        return $query->whereHas('mobileRecharges', function ($mobileRecharge) {
            $mobileRecharge->pending();
        });
    }

    public function scopeRejectedMobileRechargedUsers($query)
    {
        return $query->whereHas('mobileRecharges', function ($mobileRecharge) {
            $mobileRecharge->rejected();
        });
    }

    public function scopeHasDonationUsers($query)
    {
        return $query->whereHas('transactions', function ($transaction) {
            $transaction->where('remark', 'donation');
        });
    }

    public function scopeNotDonationUsers($query)
    {
        return $query->whereDoesntHave('transactions', function ($transaction) {
            $transaction->where('remark', 'donation');
        });
    }

    public function scopeHasUtilityBillUsers($query)
    {
        return $query->whereHas('utilityBills', function ($mobileRecharge) {
            $mobileRecharge->approved();
        });
    }

    public function scopeNotUtilityBillUsers($query)
    {
        return $query->whereDoesntHave('utilityBills', function ($mobileRecharge) {
            $mobileRecharge->approved();
        });
    }

    public function scopePendingUtilityBillUsers($query)
    {
        return $query->whereHas('utilityBills', function ($mobileRecharge) {
            $mobileRecharge->pending();
        });
    }

    public function scopeRejectedUtilityBillUsers($query)
    {
        return $query->whereHas('utilityBills', function ($mobileRecharge) {
            $mobileRecharge->rejected();
        });
    }

    public function scopeHasBankTransferredUsers($query)
    {
        return $query->whereHas('bankTransfers', function ($mobileRecharge) {
            $mobileRecharge->approved();
        });
    }

    public function scopeNotBankTransferredUsers($query)
    {
        return $query->whereDoesntHave('bankTransfers', function ($mobileRecharge) {
            $mobileRecharge->approved();
        });
    }

    public function scopePendingBankTransferredUsers($query)
    {
        return $query->whereHas('bankTransfers', function ($mobileRecharge) {
            $mobileRecharge->pending();
        });
    }

    public function scopeRejectedBankTransferredUsers($query)
    {
        return $query->whereHas('bankTransfers', function ($mobileRecharge) {
            $mobileRecharge->rejected();
        });
    }

    public function scopeHasDepositedUsers($query)
    {
        return $query->whereHas('deposits', function ($deposit) {
            $deposit->successful();
        });
    }

    public function scopeNotDepositedUsers($query)
    {
        return $query->whereDoesntHave('deposits', function ($q) {
            $q->successful();
        });
    }

    public function scopePendingDepositedUsers($query)
    {
        return $query->whereHas('deposits', function ($deposit) {
            $deposit->pending();
        });
    }

    public function scopeRejectedDepositedUsers($query)
    {
        return $query->whereHas('deposits', function ($deposit) {
            $deposit->rejected();
        });
    }

    public function scopeTopDepositedUsers($query)
    {
        return $query->whereHas('deposits', function ($deposit) {
            $deposit->successful();
        })->withSum(['deposits' => function ($q) {
            $q->successful();
        }], 'amount')->orderBy('deposits_sum_amount', 'desc')->take(request()->number_of_top_deposited_user ?? 10);
    }

    public function scopeHasWithdrawUsers($query)
    {
        return $query->whereHas('withdrawals', function ($q) {
            $q->approved();
        });
    }

    public function scopePendingWithdrawUsers($query)
    {
        return $query->whereHas('withdrawals', function ($q) {
            $q->pending();
        });
    }

    public function scopeRejectedWithdrawUsers($query)
    {
        return $query->whereHas('withdrawals', function ($q) {
            $q->rejected();
        });
    }

    public function scopePendingTicketUser($query)
    {
        return $query->whereHas('tickets', function ($q) {
            $q->whereIn('status', [Status::TICKET_OPEN, Status::TICKET_REPLY]);
        });
    }

    public function scopeClosedTicketUser($query)
    {
        return $query->whereHas('tickets', function ($q) {
            $q->where('status', Status::TICKET_CLOSE);
        });
    }

    public function scopeAnswerTicketUser($query)
    {
        return $query->whereHas('tickets', function ($q) {
            $q->where('status', Status::TICKET_ANSWER);
        });
    }

    public function scopeNotLoginUsers($query)
    {
        return $query->whereDoesntHave('loginLogs', function ($q) {
            $q->whereDate('created_at', '>=', now()->subDays(request()->number_of_days ?? 10));
        });
    }

    public function scopeKycVerified($query)
    {
        return $query->where('kv', Status::KYC_VERIFIED);
    }

}
