<?php
namespace App\Traits;

use App\Constants\Status;

trait MerchantNotify
{
    public static function notifyToMerchant()
    {
        return [
            'allMerchants'               => 'All Merchants',
            'selectedMerchants'          => 'Selected Merchants',
            'paymentReceiveMerchants'    => "Payment Receive Merchant",
            'paymentNotReceiveMerchants' => "Payment Not Receive Merchant",
            'kycUnverified'              => 'Kyc Unverified Merchants',
            'kycVerified'                => 'Kyc Verified Merchants',
            'kycPending'                 => 'Kyc Pending Merchants',
            'withBalance'                => 'With Balance Merchants',
            'emptyBalanceMerchants'      => 'Empty Balance Merchants',
            'twoFaDisableMerchants'      => '2FA Disable User',
            'twoFaEnableMerchants'       => '2FA Enable User',
            'hasWithdrawMerchants'       => 'Withdraw Merchants',
            'pendingWithdrawMerchants'   => 'Pending Withdraw Merchants',
            'rejectedWithdrawMerchants'  => 'Rejected Withdraw Merchants',
            'pendingTicketUser'          => 'Pending Ticket Merchants',
            'answerTicketUser'           => 'Answer Ticket Merchants',
            'closedTicketUser'           => 'Closed Ticket Merchants',
            'notLoginMerchants'          => 'Last Few Days Not Login Merchants',
        ];
    }

    public function scopeSelectedMerchants($query)
    {
        return $query->whereIn('id', request()->merchant ?? []);
    }

    public function scopeAllMerchants($query)
    {
        return $query;
    }

    public function scopePaymentReceiveMerchants($query)
    {
        return $query->whereHas('transactions', function ($transaction) {
            $transaction->where('remark', 'receive_payment');
        });
    }

    public function scopePaymentNotReceiveMerchants($query)
    {
        return $query->whereDoesntHave('transactions', function ($transaction) {
            $transaction->where('remark', 'receive_payment');
        });
    }

    public function scopeEmptyBalanceMerchants($query)
    {
        return $query->where('balance', '<=', 0);
    }

    public function scopeTwoFaDisableMerchants($query)
    {
        return $query->where('ts', Status::DISABLE);
    }

    public function scopeTwoFaEnableMerchants($query)
    {
        return $query->where('ts', Status::ENABLE);
    }
    
    public function scopeHasWithdrawMerchants($query)
    {
        return $query->whereHas('withdrawals', function ($q) {
            $q->approved();
        });
    }

    public function scopePendingWithdrawMerchants($query)
    {
        return $query->whereHas('withdrawals', function ($q) {
            $q->pending();
        });
    }

    public function scopeRejectedWithdrawMerchants($query)
    {
        return $query->whereHas('withdrawals', function ($q) {
            $q->rejected();
        });
    }

    public function scopePendingTicketUser($query)
    {
        return $query->whereHas('tickets', function ($q) {
            $q->whereIn('status', [Status::TICKET_OPEN, Status::TICKET_REPLY]);
        });
    }

    public function scopeClosedTicketUser($query)
    {
        return $query->whereHas('tickets', function ($q) {
            $q->where('status', Status::TICKET_CLOSE);
        });
    }

    public function scopeAnswerTicketUser($query)
    {
        return $query->whereHas('tickets', function ($q) {
            $q->where('status', Status::TICKET_ANSWER);
        });
    }

    public function scopeNotLoginMerchants($query)
    {
        return $query->whereDoesntHave('loginLogs', function ($q) {
            $q->whereDate('created_at', '>=', now()->subDays(request()->number_of_days ?? 10));
        });
    }

    public function scopeKycVerified($query)
    {
        return $query->where('kv', Status::KYC_VERIFIED);
    }

}
