<?php

namespace App\Traits;

use App\Models\Transaction;
use Carbon\Carbon;


trait Common{

    public function guard(){

        $user = auth()->user();
        $userType = strtoupper(substr($user->getTable(), 0, -1));

        if ($userType == 'USER') {
            $guard = 1;
        } 
        elseif ($userType == 'AGENT') {
            $guard = 2;
        } 
        elseif ($userType == 'MERCHANT') {
            $guard = 3;
        }

        return ['guard'=>$guard, 'user_type'=>$userType, 'user'=>$user];
    }

    public function trxLogByAPI($request){
        $search = $request->search;
        $type = $request->type;
        $operation = $request->operation;

        if ($type && $type == 'plus_trx') {
            $type = '+';
        }
        elseif($type && $type == 'minus_trx') {
            $type = '-';
        }

        $time = $request->time;
        if ($time) {
            if($time == '7days')      $time = 7;
            elseif($time == '15days') $time = 15;
            elseif($time == '30days') $time = 30;
            elseif($time == '365days')  $time = 365;
        }

        $currency = strtoupper($request->currency);
        $user = $this->guard()['user']; 
        $userType = $this->guard()['user_type'];

        $histories = Transaction::where('user_id', $user->id)->where('user_type', $userType)
            ->when($search, function ($trx, $search) {
                return  $trx->where('trx', $search); 
            })
            ->when($type, function ($trx, $type) {
                return  $trx->where('trx_type', $type);
            })
            ->when($time, function ($trx, $time) {
                return  $trx->where('created_at', '>=', Carbon::today()->subDays($time));
            })
            ->when($operation, function ($trx, $operation) {
                return  $trx->where('remark', $operation);
            }) 
        ->with(['receiverUser', 'receiverAgent', 'receiverMerchant'])->apiQuery();
            
        return $histories;
    }

}
