<?php
namespace App\Traits;

use App\Constants\Status;

trait AgentNotify
{
    public static function notifyToAgent()
    {
        return [
            'allAgents'               => 'All Agents',
            'selectedAgents'          => 'Selected Agents',

            'cashInAgents'            => "Cash In Agent",
            'notCashInAgents'         => "Not Cash In Agent",

            'cashOutReceiveAgents'    => "Cash Out Receive Agent",
            'cashOutNotReceiveAgents' => "Cash Out Not Receive Agent",

            'kycUnverified'           => 'Kyc Unverified Agents',
            'kycVerified'             => 'Kyc Verified Agents',
            'kycPending'              => 'Kyc Pending Agents',
            'withBalance'             => 'With Balance Agents',
            'emptyBalanceAgents'      => 'Empty Balance Agents',
            'twoFaDisableAgents'      => '2FA Disable User',
            'twoFaEnableAgents'       => '2FA Enable User',
            'hasDepositedAgents'      => 'Deposited Agents',
            'notDepositedAgents'      => 'Not Deposited Agents',
            'pendingDepositedAgents'  => 'Pending Deposited Agents',
            'rejectedDepositedAgents' => 'Rejected Deposited Agents',
            'topDepositedAgents'      => 'Top Deposited Agents',
            'hasWithdrawAgents'       => 'Withdraw Agents',
            'pendingWithdrawAgents'   => 'Pending Withdraw Agents',
            'rejectedWithdrawAgents'  => 'Rejected Withdraw Agents',
            'pendingTicketUser'       => 'Pending Ticket Agents',
            'answerTicketUser'        => 'Answer Ticket Agents',
            'closedTicketUser'        => 'Closed Ticket Agents',
            'notLoginAgents'          => 'Last Few Days Not Login Agents',
        ];
    }

    public function scopeSelectedAgents($query)
    {
        return $query->whereIn('id', request()->agent ?? []);
    }

    public function scopeAllAgents($query)
    {
        return $query;
    }

    public function scopeCashInAgents($query)
    {
        return $query->whereHas('transactions', function($transaction){
            $transaction->where('remark', 'cash_in');
        });
    }
    
    public function scopeNotCashInAgents($query)
    {
        return $query->whereDoesntHave('transactions', function($transaction){
            $transaction->where('remark', 'cash_in');
        });
    }

    public function scopeCashOutReceiveAgents($query){
        return $query->whereHas('transactions', function($transaction){
            $transaction->where('remark', 'cash_out');
        });
    }

    public function scopeCashOutNotReceiveAgents($query){
        return $query->whereDoesntHave('transactions', function($transaction){
            $transaction->where('remark', 'cash_out');
        });
    }

    public function scopeEmptyBalanceAgents($query)
    {
        return $query->where('balance', '<=', 0);
    }

    public function scopeTwoFaDisableAgents($query)
    {
        return $query->where('ts', Status::DISABLE);
    }

    public function scopeTwoFaEnableAgents($query)
    {
        return $query->where('ts', Status::ENABLE);
    }

    public function scopeHasDepositedAgents($query)
    {
        return $query->whereHas('deposits', function ($deposit) {
            $deposit->successful();
        });
    }

    public function scopeNotDepositedAgents($query)
    {
        return $query->whereDoesntHave('deposits', function ($q) {
            $q->successful();
        });
    }

    public function scopePendingDepositedAgents($query)
    {
        return $query->whereHas('deposits', function ($deposit) {
            $deposit->pending();
        });
    }

    public function scopeRejectedDepositedAgents($query)
    {
        return $query->whereHas('deposits', function ($deposit) {
            $deposit->rejected();
        });
    }

    public function scopeTopDepositedAgents($query)
    {
        return $query->whereHas('deposits', function ($deposit) {
            $deposit->successful();
        })->withSum(['deposits' => function ($q) {
            $q->successful();
        }], 'amount')->orderBy('deposits_sum_amount', 'desc')->take(request()->number_of_top_deposited_agent ?? 10);
    }

    public function scopeHasWithdrawAgents($query)
    {
        return $query->whereHas('withdrawals', function ($q) {
            $q->approved();
        });
    }

    public function scopePendingWithdrawAgents($query)
    {
        return $query->whereHas('withdrawals', function ($q) {
            $q->pending();
        });
    }

    public function scopeRejectedWithdrawAgents($query)
    {
        return $query->whereHas('withdrawals', function ($q) {
            $q->rejected();
        });
    }

    public function scopePendingTicketUser($query)
    {
        return $query->whereHas('tickets', function ($q) {
            $q->whereIn('status', [Status::TICKET_OPEN, Status::TICKET_REPLY]);
        });
    }

    public function scopeClosedTicketUser($query)
    {
        return $query->whereHas('tickets', function ($q) {
            $q->where('status', Status::TICKET_CLOSE);
        });
    }

    public function scopeAnswerTicketUser($query)
    {
        return $query->whereHas('tickets', function ($q) {
            $q->where('status', Status::TICKET_ANSWER);
        });
    }

    public function scopeNotLoginAgents($query)
    {
        return $query->whereDoesntHave('loginLogs', function ($q) {
            $q->whereDate('created_at', '>=', now()->subDays(request()->number_of_days ?? 10));
        });
    }

    public function scopeKycVerified($query)
    {
        return $query->where('kv', Status::KYC_VERIFIED);
    }

}
