<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Model;
use App\Traits\ApiQuery;

class Voucher extends Model
{
    use HasFactory, ApiQuery;

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id')->where('user_type', 'USER');
    }

    public function usedTime(){
        $time = trans('N/A');
        
        if ($this->is_used == 1){
            $time = showDateTime($this->updated_at, 'd M Y @g:h:a');
        }
        
        return $time;
    }

}
