<?php

namespace App\Models;

use App\Constants\Status;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserWithdrawMethod extends Model
{

    use HasFactory;

    protected $appends = ['min_limit', 'max_limit'];

    protected $casts = [
        'user_data' => 'object',

    ];

    public function withdrawMethod()
    {
        return $this->belongsTo(WithdrawMethod::class, 'method_id');
    }

    public function scopeMyWithdrawMethod()
    {

        $currentUser = userGuard();
        $user        = $currentUser['user'];
        $userType    = $currentUser['type'];
        $guard       = $currentUser['guard'];

        return $this->where('user_type', $userType)->where('user_id', $user->id)->whereHas('withdrawMethod', function ($query) use ($guard) {
            $query->where('status', Status::ENABLE)->whereJsonContains('user_guards', "$guard");
        });
    }

    public function minLimit(): Attribute
    {
        return new Attribute(
            get: function () {
                return getAmount($this->withdrawMethod->min_limit);
            }
        );
    }

    public function maxLimit(): Attribute
    {
        return new Attribute(
            get: function () {
                return getAmount($this->withdrawMethod->max_limit);
            }
        );
    }

}
