<?php

namespace App\Models;

use App\Traits\ApiQuery;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Casts\Attribute;

class Transaction extends Model
{
    use ApiQuery;

    public function mobileRecharge()
    {
        return $this->hasOne(MobileRecharge::class, 'trx', 'trx');
    }

    public function bankTransfer()
    {
        return $this->hasOne(BankTransfer::class, 'trx', 'trx');
    }

    public function savingInstallment()
    {
        return $this->belongsTo(SavingInstallment::class, 'saving_installment_id', 'id');
    }

    public function utilityBill()
    {
        return $this->hasOne(UtilityBill::class, 'trx', 'trx');
    }

    public function deposit()
    {
        return $this->hasOne(Deposit::class, 'trx', 'trx');
    }

    public function withdraw()
    {
        return $this->hasOne(Withdrawal::class, 'trx', 'trx');
    }

    public function operator()
    {
        return $this->belongsTo(Operator::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function agent()
    {
        return $this->belongsTo(Agent::class, 'user_id');
    }

    public function merchant()
    {
        return $this->belongsTo(Merchant::class, 'user_id');
    }

    public function donationFor()
    {
        return $this->belongsTo(SetupDonation::class, 'setup_donation_id', 'id');
    }

    public function scopeCommission($query)
    {
        return $query->where('remark', 'commission');
    }

    public function scopeForUser($query)
    {
        return $query->where('user_id', user()->id)->where('user_type', 'USER');
    }

    public function scopeForAgent($query)
    {
        return $query->where('user_id', agent()->id)->where('user_type', 'AGENT');
    }

    public function scopeForMerchant($query)
    {
        return $query->where('user_id', merchant()->id)->where('user_type', 'MERCHANT');
    }

    public function receiverUser()
    {
        return $this->belongsTo(User::class, 'receiver_id');
    }

    public function receiverAgent()
    {
        return $this->belongsTo(Agent::class, 'receiver_id');
    }

    public function receiverMerchant()
    {
        return $this->belongsTo(Merchant::class, 'receiver_id');
    }

    public function relatedTransaction()
    {
        return $this->hasOne(Transaction::class, 'trx', 'trx');
    }

    public function getUser(): Attribute
    {
        return new Attribute(
            get: function () {
                if ($this->user_type == 'USER') {
                    $user = $this->user;
                } elseif ($this->user_type == 'AGENT') {
                    $user = $this->agent;
                } elseif ($this->user_type == 'MERCHANT') {
                    $user = $this->merchant;
                }

                return @$user;
            },
        );
    }

    public function getReceiverAttribute()
    {

        $user = null;
        if ($this->receiverUser && $this->receiver_type == 'USER') {
            $user = $this->receiverUser;
        } elseif ($this->receiverAgent && $this->receiver_type == 'AGENT') {
            $user = $this->receiverAgent;
        } elseif ($this->receiverMerchant && $this->receiver_type == 'MERCHANT') {
            $user = $this->receiverMerchant;
        }

        return $user;
    }
}
