<?php

namespace App\Models;

use App\Constants\Status;
use App\Traits\GlobalStatus;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Casts\Attribute;

class SetupUtilityBill extends Model
{
    use GlobalStatus;

    protected $appends = [];

    public function __construct()
    {
        if (request()->is('api/*')) {
            $this->appends[] = 'get_image';
        }
    }

    public function getGetImageAttribute()
    {
        return getImage(getFilePath('setup_utility') . '/' . $this->image, getFileSize('setup_utility'));
    }

    public function form()
    {
        return $this->belongsTo(Form::class);
    }

    public function scopeAutoPayable($q){
        return $q->where('auto_payment',Status::YES);
    }

    public function autoPaymentBadge(): Attribute
    {
        return new Attribute(function () {
            $html = '';
            if ($this->auto_payment == Status::YES) {
                $html = '<span class="badge badge--success">' . trans('Enabled') . '</span>';
            } else {
                $html = '<span class="badge badge--warning">' . trans('Disabled') . '</span>';
            }
            return $html;
        });
    }
}
