<?php

namespace App\Models;

use App\Traits\GlobalStatus;
use Illuminate\Database\Eloquent\Model;

class SetupBankTransfer extends Model
{
    use GlobalStatus;

    public function __construct()
    {
        if (request()->is('api/*')) {
            $this->appends[] = 'get_image';
        }
    }

    public function getGetImageAttribute()
    {
        return getImage(getFilePath('setup_bank') . '/' . $this->image, getFileSize('setup_bank'));
    }

    public function form()
    {
        return $this->belongsTo(Form::class);
    }
}
