<?php

namespace App\Models;

use App\Constants\Status;
use App\Traits\ApiQuery;
use App\Traits\GlobalStatus;
use Illuminate\Database\Eloquent\Model;

class SavingInstallment extends Model
{
    use GlobalStatus, ApiQuery;

    public function savingAccount()
    {
        return $this->belongsTo(SavingAccount::class, 'saving_account_id');
    }

    public function transaction()
    {
        return $this->hasOne(Transaction::class, 'saving_installment_id', 'id');
    }

    // scope 
    public function scopePaid($query)
    {
        return $query->where('status', Status::INSTALLMENT_PAID);
    }

    public function scopeUnpaid($query)
    {
        return $query->where('status', Status::INSTALLMENT_UNPAID);
    }
}
