<?php

namespace App\Models;

use App\Constants\Status;
use App\Traits\ApiQuery;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Model;

class SavingAccount extends Model
{
    use ApiQuery;
    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'nominee_data' => 'object',
        'next_installment_date' => 'datetime',
        'last_installment_at' => 'datetime'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function nominee()
    {
        return $this->belongsTo(Nominee::class);
    }

    public function dpsPlan()
    {
        return $this->belongsTo(DpsPlan::class);
    }

    public function installments()
    {
        return $this->hasMany(SavingInstallment::class, 'saving_account_id', 'id');
    }

    public function statusBadge(): Attribute
    {
        return new Attribute(function () {
            $html = '';
            if ($this->status == Status::ACCOUNT_RUNNING) {
                $html = '<span class="badge badge--primary">' . trans('Active') . '</span>';
            } elseif ($this->status == Status::ACCOUNT_MATURED) {
                $html = '<span class="badge badge--success">' . trans('Matured') . '</span>';
            } elseif ($this->status == Status::ACCOUNT_CLOSED) {
                $html = '<span><span class="badge badge--danger">' . trans('Closed') . '</span>';
            }
            return $html;
        });
    }

    // scope 
    public function scopeRunning($query)
    {
        return $query->where('status', Status::ACCOUNT_RUNNING);
    }

    public function scopeMatured($query)
    {
        return $query->where('status', Status::ACCOUNT_MATURED);
    }

    public function scopeClosed($query)
    {
        return $query->where('status', Status::ACCOUNT_CLOSED);
    }
}
