<?php

namespace App\Models;

use App\Constants\Status;
use App\Traits\GlobalStatus;
use Illuminate\Database\Eloquent\Model;

class Reward extends Model
{
    use GlobalStatus;

    public function level()
    {
        return $this->belongsTo(Level::class);
    }

    // scope
    public function scopeActive($query)
    {
        return $query->where('status', Status::ENABLE);
    }
}
