<?php

namespace App\Models;

use App\Constants\Status;
use Illuminate\Database\Eloquent\Model;

class RedeemReward extends Model
{
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function reward()
    {
        return $this->belongsTo(Reward::class);
    }

    // scope 
    public function scopeActive($query)
    {
        return $query->where('status', Status::REDEEM_ACTIVE);
    }
}
