<?php

namespace App\Models;

use App\Constants\Status;
use Illuminate\Database\Eloquent\Model;

class PointLog extends Model
{
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // scope 
    public function scopeAvailable($query)
    {
        return $query->where('status', Status::POINT_AVAILABLE);
    }

    public function scopeExpired($query)
    {
        return $query->where('status', Status::POINT_EXPIRED);
    }
}
