<?php

namespace App\Models;

use App\Constants\Status;
use App\Traits\ApiQuery;
use App\Traits\GlobalStatus;
use Illuminate\Database\Eloquent\Model;

class Organization extends Model
{
    use GlobalStatus, ApiQuery;


    public function dpsPlans()
    {
        return $this->hasMany(DpsPlan::class);
    }

    // Scope 
    public function scopeActive($query)
    {
        return $query->where('status', Status::ENABLE);
    }
}
