<?php

namespace App\Models;

use App\Traits\GlobalStatus;
use Illuminate\Database\Eloquent\Model;

class MobileOperator extends Model
{
    use GlobalStatus;

    protected $appends = [];

    public function __construct()
    {
        if (request()->is('api/*')) {
            $this->appends[] = 'get_image';
        }
    }

    public function getGetImageAttribute()
    {
        return getImage(getFilePath('mobile_operator') . '/' . $this->image, getFileSize('mobile_operator'));
    }
}
